/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.lzma;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LzmaDecoderOutputStream
extends OutputStream {
    private final LinkedBlockingQueue<byte[]> m_dataQueue;
    private boolean m_closed;
    private boolean m_interrupted;

    LzmaDecoderOutputStream(LinkedBlockingQueue<byte[]> linkedBlockingQueue) {
        this.m_dataQueue = linkedBlockingQueue;
    }

    private void assertNotClosed() throws IOException {
        if (this.m_closed) {
            throw new IOException("This stream is closed");
        }
    }

    private void put(byte[] byArray) throws IOException {
        try {
            this.m_dataQueue.put(byArray);
        }
        catch (InterruptedException interruptedException) {
            this.m_interrupted = true;
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.assertNotClosed();
        this.put(new byte[]{(byte)(n & 0xFF)});
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.assertNotClosed();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.put(byArray2);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.assertNotClosed();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.put(byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.m_closed) {
            try {
                if (!this.m_interrupted) {
                    try {
                        this.m_dataQueue.put(new byte[0]);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                super.close();
            }
            finally {
                this.m_closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

