/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.lzma;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LzmaEncoderInputStream
extends InputStream {
    private final LinkedBlockingQueue<byte[]> m_dataQueue;
    private byte[] m_curData;
    private int m_posInCurData;
    private boolean m_closed;

    LzmaEncoderInputStream(LinkedBlockingQueue<byte[]> linkedBlockingQueue) {
        this.m_dataQueue = linkedBlockingQueue;
    }

    private void testAndSetCurData() {
        if (this.m_curData == null || this.m_posInCurData >= this.m_curData.length) {
            if (this.m_curData != null && this.m_curData.length == 0) {
                return;
            }
            try {
                this.m_curData = this.m_dataQueue.take();
                this.m_posInCurData = 0;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void assertNotClosed() throws IOException {
        if (this.m_closed) {
            throw new IOException("This stream is closed");
        }
    }

    private boolean isAtEof() {
        return this.m_curData.length == 0;
    }

    @Override
    public int available() throws IOException {
        this.assertNotClosed();
        this.testAndSetCurData();
        return this.m_curData.length - this.m_posInCurData;
    }

    @Override
    public int read() throws IOException {
        this.assertNotClosed();
        this.testAndSetCurData();
        if (this.isAtEof()) {
            return -1;
        }
        return this.m_curData[this.m_posInCurData++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    private int readInternal(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.m_curData.length - this.m_posInCurData;
            if (n4 > n2) {
                System.arraycopy(this.m_curData, this.m_posInCurData, byArray, n + n3, n2);
                this.m_posInCurData += n2;
                return n3 += n2;
            }
            System.arraycopy(this.m_curData, this.m_posInCurData, byArray, n + n3, n4);
            n3 += n4;
            this.m_curData = null;
            if (n4 == n2) {
                return n3;
            }
            n2 -= n4;
            this.testAndSetCurData();
            if (!this.isAtEof()) continue;
            return n3;
        }
        return n3;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.assertNotClosed();
        if (n < 0) {
            throw new IndexOutOfBoundsException("Invalid offset " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Invalid length " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Invalid offset + length " + n + " + " + n2 + ". Array length " + byArray.length);
        }
        if (n2 == 0) {
            return 0;
        }
        this.testAndSetCurData();
        if (this.isAtEof()) {
            return -1;
        }
        return this.readInternal(byArray, n, n2);
    }

    @Override
    public long skip(long l) throws IOException {
        this.assertNotClosed();
        long l2 = 0L;
        while (l > 0L) {
            this.testAndSetCurData();
            if (this.isAtEof()) {
                return l2;
            }
            if ((long)this.m_curData.length > l + (long)this.m_posInCurData) {
                this.m_posInCurData += (int)l;
                return l2 + l;
            }
            l2 += (long)(this.m_curData.length - this.m_posInCurData);
            l -= (long)this.m_curData.length;
            this.m_curData = null;
            this.m_posInCurData = 0;
        }
        return l2;
    }

    @Override
    public void close() {
        this.m_closed = true;
    }
}

