/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.lzma;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.LinkedBlockingQueue;
import org.at4j.comp.lzma.LzmaDecoderOutputStream;
import org.at4j.comp.lzma.LzmaErrorState;
import org.at4j.comp.lzma.LzmaInputStreamSettings;
import org.at4j.comp.lzma.LzmaReaderRunnable;

public final class LzmaInputStream
extends InputStream {
    private final Thread m_readerThread;
    private final LzmaErrorState m_errorState;
    private final LinkedBlockingQueue<byte[]> m_dataQueue;
    private final InputStream m_wrapped;
    private boolean m_closed;
    private byte[] m_curBlock;
    private int m_curPosInBlock;

    public LzmaInputStream(InputStream inputStream) {
        this(inputStream, new LzmaInputStreamSettings());
    }

    public LzmaInputStream(InputStream inputStream, LzmaInputStreamSettings lzmaInputStreamSettings) throws IllegalArgumentException {
        if (lzmaInputStreamSettings.getUncompressedSize() < -1L) {
            throw new IllegalArgumentException("Invalid uncompressed size of data: " + lzmaInputStreamSettings.getUncompressedSize());
        }
        this.m_wrapped = inputStream;
        this.m_errorState = new LzmaErrorState();
        this.m_dataQueue = new LinkedBlockingQueue(lzmaInputStreamSettings.getMaxDataQueueDepth());
        LzmaReaderRunnable lzmaReaderRunnable = new LzmaReaderRunnable(inputStream, this.m_errorState, new LzmaDecoderOutputStream(this.m_dataQueue), lzmaInputStreamSettings);
        this.m_readerThread = lzmaInputStreamSettings.getThreadFactory() != null ? lzmaInputStreamSettings.getThreadFactory().newThread(lzmaReaderRunnable) : new Thread(lzmaReaderRunnable);
        this.m_readerThread.start();
    }

    private void assertNotClosed() throws IOException {
        if (this.m_closed) {
            throw new IOException("This stream is closed");
        }
    }

    private void testAndSetDataBlock() throws IOException {
        if (this.m_curBlock == null || this.m_curPosInBlock >= this.m_curBlock.length) {
            if (this.m_curBlock != null && this.m_curBlock.length == 0) {
                return;
            }
            try {
                this.m_curBlock = this.m_dataQueue.take();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            this.m_curPosInBlock = 0;
            this.m_errorState.testAndClearErrors();
        }
    }

    private boolean isAtEof() {
        return this.m_curBlock.length == 0;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        return n == -1 ? -1 : byArray[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.assertNotClosed();
        this.m_errorState.testAndClearErrors();
        int n3 = 0;
        while (n2 > 0) {
            this.testAndSetDataBlock();
            if (this.isAtEof() || Thread.currentThread().isInterrupted()) {
                return n3 == 0 ? -1 : n3;
            }
            int n4 = this.m_curBlock.length - this.m_curPosInBlock;
            if (n2 <= n4) {
                System.arraycopy(this.m_curBlock, this.m_curPosInBlock, byArray, n, n2);
                this.m_curPosInBlock += n2;
                return n3 += n2;
            }
            if (n4 <= 0) continue;
            System.arraycopy(this.m_curBlock, this.m_curPosInBlock, byArray, n, n4);
            n += n4;
            n3 += n4;
            n2 -= n4;
            this.m_curBlock = null;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.m_closed) {
            try {
                try {
                    this.m_readerThread.interrupt();
                    try {
                        this.m_readerThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                finally {
                    this.m_wrapped.close();
                }
            }
            finally {
                this.m_closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

