/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.lzma;

import java.util.concurrent.ThreadFactory;

public class LzmaInputStreamSettings {
    public static final boolean DEFAULT_READ_UNCOMPRESSED_SIZE = true;
    public static final int DEFAULT_MAX_DATA_QUEUE_DEPTH = 1;
    private boolean m_readUncompressedSize = true;
    private long m_uncompressedSize = -1L;
    private byte[] m_properties = null;
    private int m_maxDataQueueDepth = 1;
    private ThreadFactory m_threadFactory;

    public LzmaInputStreamSettings setReadUncompressedSize(boolean bl) {
        this.m_readUncompressedSize = bl;
        return this;
    }

    public boolean isReadUncompressedSize() {
        return this.m_readUncompressedSize;
    }

    public LzmaInputStreamSettings setUncompressedSize(long l) throws IllegalArgumentException {
        if (l < -1L) {
            throw new IllegalArgumentException("Invalid uncompressed data size " + l);
        }
        this.m_uncompressedSize = l;
        return this;
    }

    public long getUncompressedSize() {
        return this.m_uncompressedSize;
    }

    public LzmaInputStreamSettings setProperties(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length != 5) {
            throw new IllegalArgumentException("Invalid size of decoder properties: " + byArray.length + " bytes. It must be five bytes long");
        }
        this.m_properties = new byte[5];
        System.arraycopy(byArray, 0, this.m_properties, 0, 5);
        return this;
    }

    public byte[] getProperties() {
        if (this.m_properties == null) {
            return null;
        }
        assert (this.m_properties.length == 5);
        byte[] byArray = new byte[5];
        System.arraycopy(this.m_properties, 0, byArray, 0, 5);
        return byArray;
    }

    public LzmaInputStreamSettings setMaxDataQueueDepth(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid maximum data queue depth " + n + ". It must be at least 1");
        }
        this.m_maxDataQueueDepth = n;
        return this;
    }

    public int getMaxDataQueueDepth() {
        return this.m_maxDataQueueDepth;
    }

    public LzmaInputStreamSettings setThreadFactory(ThreadFactory threadFactory) {
        this.m_threadFactory = threadFactory;
        return this;
    }

    public ThreadFactory getThreadFactory() {
        return this.m_threadFactory;
    }
}

