/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.lzma;

import SevenZip.Compression.LZMA.Encoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.LinkedBlockingQueue;
import org.at4j.comp.lzma.LzmaEncoderInputStream;
import org.at4j.comp.lzma.LzmaErrorState;
import org.at4j.comp.lzma.LzmaOutputStreamSettings;
import org.at4j.comp.lzma.LzmaWriterRunnable;
import org.at4j.support.lang.At4JException;

public final class LzmaOutputStream
extends OutputStream {
    private final Thread m_writerThread;
    private final LzmaErrorState m_errorState;
    private final LinkedBlockingQueue<byte[]> m_dataQueue;
    private final OutputStream m_wrapped;
    private boolean m_closed;

    public LzmaOutputStream(OutputStream outputStream) {
        this(outputStream, new LzmaOutputStreamSettings(), -1L);
    }

    public LzmaOutputStream(OutputStream outputStream, LzmaOutputStreamSettings lzmaOutputStreamSettings) {
        this(outputStream, lzmaOutputStreamSettings, -1L);
    }

    public LzmaOutputStream(OutputStream outputStream, LzmaOutputStreamSettings lzmaOutputStreamSettings, long l) throws IllegalArgumentException {
        if (l == 0L || l < -1L) {
            throw new IllegalArgumentException("Illegal data size: " + l);
        }
        Encoder encoder = new Encoder();
        encoder.SetDictionarySize(1 << lzmaOutputStreamSettings.getDictionarySizeExponent());
        encoder.SetLcLpPb(lzmaOutputStreamSettings.getNumberOfLiteralContextBits(), lzmaOutputStreamSettings.getNumberOfLiteralPosBits(), lzmaOutputStreamSettings.getNumberOfPosBits());
        encoder.SetMatchFinder(lzmaOutputStreamSettings.getMatchFinderAlgorithm().getId());
        encoder.SetEndMarkerMode(l == -1L);
        this.m_dataQueue = lzmaOutputStreamSettings.getMaxDataQueueSize() != 0 ? new LinkedBlockingQueue(lzmaOutputStreamSettings.getMaxDataQueueSize()) : new LinkedBlockingQueue();
        this.m_errorState = new LzmaErrorState();
        this.m_wrapped = outputStream;
        LzmaWriterRunnable lzmaWriterRunnable = new LzmaWriterRunnable(new LzmaEncoderInputStream(this.m_dataQueue), encoder, lzmaOutputStreamSettings, l, this.m_errorState, outputStream);
        this.m_writerThread = lzmaOutputStreamSettings.getThreadFactory() != null ? lzmaOutputStreamSettings.getThreadFactory().newThread(lzmaWriterRunnable) : new Thread(lzmaWriterRunnable);
        this.m_writerThread.start();
    }

    private void assertNotClosed() throws IOException {
        if (this.m_closed) {
            throw new IOException("This stream is closed");
        }
    }

    private void put(byte[] byArray) {
        try {
            this.m_dataQueue.put(byArray);
        }
        catch (InterruptedException interruptedException) {
            throw new At4JException(interruptedException);
        }
    }

    public void write(int n) throws IOException {
        this.assertNotClosed();
        this.m_errorState.testAndClearErrors();
        this.put(new byte[]{(byte)(n & 0xFF)});
    }

    public void write(byte[] byArray) throws IOException {
        this.assertNotClosed();
        this.m_errorState.testAndClearErrors();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.put(byArray2);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.assertNotClosed();
        if (n < 0) {
            throw new IndexOutOfBoundsException("Illegal offset " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Illegal length " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Offset + length (" + n + " + " + n2 + ") is greater than the length of the supplied array (" + byArray.length + ")");
        }
        this.m_errorState.testAndClearErrors();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.put(byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.m_closed) {
            try {
                try {
                    this.put(new byte[0]);
                    try {
                        this.m_writerThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException(interruptedException.toString());
                    }
                }
                finally {
                    this.m_wrapped.close();
                }
            }
            finally {
                this.m_closed = true;
                super.close();
            }
            this.m_errorState.testAndClearErrors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

