/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.lzma;

import java.util.concurrent.ThreadFactory;
import org.at4j.comp.CompressionLevel;
import org.at4j.comp.lzma.MatchFinderAlgorithm;

public class LzmaOutputStreamSettings {
    public static final int DEFAULT_DICTIONARY_SIZE_EXPONENT = 23;
    public static final int DEFAULT_NUMBER_OF_LITERAL_CONTEXT_BITS = 3;
    public static final int DEFAULT_NUMBER_OF_LITERAL_POS_BITS = 0;
    public static final int DEFAULT_NUMBER_OF_POS_BITS = 2;
    public static final MatchFinderAlgorithm DEFAULT_MATCH_FINDER_ALGORITHM = MatchFinderAlgorithm.BINARY_TREE_4;
    public static final int DEFAULT_MAX_DATA_QUEUE_SIZE = 0;
    public static final boolean DEFAULT_WRITE_STREAM_PROPERTIES = true;
    public static final boolean DEFAULT_WRITE_UNCOMPRESSED_DATA_SIZE = true;
    static final int BUFFER_SIZE_NOT_SET = -1;
    private int m_dictionarySizeExponent = 23;
    private int m_numberOfLiteralContextBits = 3;
    private int m_numberOfLiteralPosBits = 0;
    private int m_numberOfPosBits = 2;
    private MatchFinderAlgorithm m_matchFinderAlgorithm = DEFAULT_MATCH_FINDER_ALGORITHM;
    private int m_maxDataQueueSize = 0;
    private boolean m_writeStreamProperties = true;
    private boolean m_writeUncompressedDataSize = true;
    private int m_bufferSize = -1;
    private ThreadFactory m_threadFactory;

    public LzmaOutputStreamSettings setDictionarySizeExponent(int n) throws IllegalArgumentException {
        if (n < 0 || n > 30) {
            throw new IllegalArgumentException("Illegal dictionary size " + n + ". It must be between 0 and 30 (inclusive).");
        }
        this.m_dictionarySizeExponent = n;
        return this;
    }

    public int getDictionarySizeExponent() {
        return this.m_dictionarySizeExponent;
    }

    public LzmaOutputStreamSettings setNumberOfLiteralContextBits(int n) throws IllegalArgumentException {
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException("Illegal number of context bits " + n + ". The value must be between 0 and 8 (inclusive).");
        }
        this.m_numberOfLiteralContextBits = n;
        return this;
    }

    public int getNumberOfLiteralContextBits() {
        return this.m_numberOfLiteralContextBits;
    }

    public LzmaOutputStreamSettings setNumberOfLiteralPosBits(int n) throws IllegalArgumentException {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Illegal number of literal pos bits " + n + " The value must be between 0 and 4 (inclusive).");
        }
        this.m_numberOfLiteralPosBits = n;
        return this;
    }

    public int getNumberOfLiteralPosBits() {
        return this.m_numberOfLiteralPosBits;
    }

    public LzmaOutputStreamSettings setNumberOfPosBits(int n) throws IllegalArgumentException {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Illegal number of pos bits " + n + ". The value must be between 0 and 4 (inclusive).");
        }
        this.m_numberOfPosBits = n;
        return this;
    }

    public int getNumberOfPosBits() {
        return this.m_numberOfPosBits;
    }

    public LzmaOutputStreamSettings setMatchFinderAlgorithm(MatchFinderAlgorithm matchFinderAlgorithm) throws NullPointerException {
        ((Object)((Object)matchFinderAlgorithm)).getClass();
        this.m_matchFinderAlgorithm = matchFinderAlgorithm;
        return this;
    }

    public MatchFinderAlgorithm getMatchFinderAlgorithm() {
        return this.m_matchFinderAlgorithm;
    }

    public LzmaOutputStreamSettings setMaxDataQueueSize(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid max size " + n);
        }
        this.m_maxDataQueueSize = n;
        return this;
    }

    public int getMaxDataQueueSize() {
        return this.m_maxDataQueueSize;
    }

    public LzmaOutputStreamSettings setWriteStreamProperties(boolean bl) {
        this.m_writeStreamProperties = bl;
        return this;
    }

    public boolean isWriteStreamProperties() {
        return this.m_writeStreamProperties;
    }

    public LzmaOutputStreamSettings setWriteUncompressedDataSize(boolean bl) {
        this.m_writeUncompressedDataSize = bl;
        return this;
    }

    public boolean isWriteUncompressedDataSize() {
        return this.m_writeUncompressedDataSize;
    }

    public LzmaOutputStreamSettings setBufferSize(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid buffer size " + n + ". It must be > 0");
        }
        this.m_bufferSize = n;
        return this;
    }

    public int getBufferSize() {
        return this.m_bufferSize;
    }

    public LzmaOutputStreamSettings setCompressionLevel(CompressionLevel compressionLevel) {
        switch (compressionLevel) {
            case BEST: {
                this.m_dictionarySizeExponent = 30;
                this.m_numberOfLiteralContextBits = 4;
                break;
            }
            case DEFAULT: {
                this.m_dictionarySizeExponent = 23;
                this.m_numberOfLiteralContextBits = 3;
                break;
            }
            case FASTEST: {
                this.m_dictionarySizeExponent = 20;
                this.m_numberOfLiteralContextBits = 3;
                break;
            }
            default: {
                throw new RuntimeException("Unknown compression level. This is a bug.");
            }
        }
        return this;
    }

    public LzmaOutputStreamSettings setThreadFactory(ThreadFactory threadFactory) {
        this.m_threadFactory = threadFactory;
        return this;
    }

    public ThreadFactory getThreadFactory() {
        return this.m_threadFactory;
    }

    public byte[] getProperties() {
        byte[] byArray = new byte[5];
        byArray[0] = (byte)((this.m_numberOfPosBits * 5 + this.m_numberOfLiteralPosBits) * 9 + this.m_numberOfLiteralContextBits);
        int n = 1 << this.m_dictionarySizeExponent;
        for (int i = 0; i < 4; ++i) {
            byArray[1 + i] = (byte)(n >> 8 * i);
        }
        return byArray;
    }
}

