/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.lzma;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.at4j.comp.lzma.LzmaInputStream;
import org.entityfs.ReadableFile;
import org.entityfs.exception.LockTimeoutException;
import org.entityfs.lock.EntityLock;
import org.entityfs.lock.ReadLockRequiredException;
import org.entityfs.security.AccessDeniedException;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.support.io.StreamUtil;

public class LzmaReadableFile
implements ReadableFile {
    private static final int BUFFER_SIZE_NOT_SET = -1;
    private final ReadableFile m_adapted;
    private final int m_bufferSize;

    public LzmaReadableFile(ReadableFile readableFile) {
        readableFile.getClass();
        this.m_adapted = readableFile;
        this.m_bufferSize = -1;
    }

    public LzmaReadableFile(ReadableFile readableFile, int n) throws IllegalArgumentException {
        readableFile.getClass();
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid buffer size " + n + ". It must be > 0");
        }
        this.m_adapted = readableFile;
        this.m_bufferSize = n;
    }

    public ReadableByteChannel openChannelForRead() throws ReadLockRequiredException, AccessDeniedException {
        return Channels.newChannel(this.openForRead());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openForRead() throws ReadLockRequiredException, AccessDeniedException {
        LzmaInputStream lzmaInputStream;
        block6: {
            boolean bl = false;
            BufferedInputStream bufferedInputStream = this.m_bufferSize == -1 ? new BufferedInputStream(this.m_adapted.openForRead()) : new BufferedInputStream(this.m_adapted.openForRead(), this.m_bufferSize);
            try {
                LzmaInputStream lzmaInputStream2 = new LzmaInputStream(bufferedInputStream);
                bl = true;
                lzmaInputStream = lzmaInputStream2;
                if (bl) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (!bl) {
                        ((InputStream)bufferedInputStream).close();
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new WrappedIOException(iOException);
                }
            }
            ((InputStream)bufferedInputStream).close();
        }
        return lzmaInputStream;
    }

    public EntityLock getReadLock() {
        return this.m_adapted.getReadLock();
    }

    public boolean isReadLockedByCurrentThread() throws IllegalStateException {
        return this.m_adapted.isReadLockedByCurrentThread();
    }

    public EntityLock lockForReading() throws LockTimeoutException {
        return this.m_adapted.lockForReading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDataSize() throws ReadLockRequiredException, AccessDeniedException {
        long l;
        InputStream inputStream = this.openForRead();
        try {
            l = StreamUtil.getSizeOfDataInStream((InputStream)inputStream, (int)8192);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new WrappedIOException(iOException);
            }
        }
        inputStream.close();
        return l;
    }

    public long getSize() throws ReadLockRequiredException, AccessDeniedException {
        return this.m_adapted.getSize();
    }
}

