/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.lzma;

import SevenZip.Compression.LZMA.Decoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.at4j.comp.lzma.LzmaDecoderOutputStream;
import org.at4j.comp.lzma.LzmaErrorState;
import org.at4j.comp.lzma.LzmaInputStreamSettings;
import org.at4j.support.lang.UnsignedLong;

final class LzmaReaderRunnable
implements Runnable {
    private static final int STREAM_PROPERTIES_SIZE = 5;
    private final LzmaErrorState m_errorState;
    private final LzmaDecoderOutputStream m_queueStream;
    private final InputStream m_inStream;
    private final LzmaInputStreamSettings m_settings;

    LzmaReaderRunnable(InputStream inputStream, LzmaErrorState lzmaErrorState, LzmaDecoderOutputStream lzmaDecoderOutputStream, LzmaInputStreamSettings lzmaInputStreamSettings) {
        this.m_inStream = inputStream;
        this.m_errorState = lzmaErrorState;
        this.m_queueStream = lzmaDecoderOutputStream;
        this.m_settings = lzmaInputStreamSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                byte[] byArray;
                if (this.m_settings.getProperties() != null) {
                    byArray = this.m_settings.getProperties();
                } else {
                    byArray = new byte[5];
                    int n = this.m_inStream.read(byArray);
                    if (n != 5) {
                        throw new IOException("Wanted to read 5 bytes. Got " + n);
                    }
                }
                long l = this.m_settings.isReadUncompressedSize() ? UnsignedLong.readBigEndian(this.m_inStream).longValue() : -1L;
                l = Math.max(l, this.m_settings.getUncompressedSize());
                Decoder decoder = new Decoder();
                if (!decoder.SetDecoderProperties(byArray, l)) {
                    throw new IOException("Could not set LZMA decoder properties from the data in the supplied stream. No reason given.");
                }
                if (!decoder.Code(this.m_inStream, (OutputStream)this.m_queueStream, l)) {
                    throw new IOException("Could not decode stream. No reason given.");
                }
            }
            finally {
                this.m_queueStream.close();
            }
        }
        catch (IOException iOException) {
            this.m_errorState.setIoException(iOException);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (RuntimeException runtimeException) {
            this.m_errorState.setRuntimeException(runtimeException);
        }
        catch (Error error) {
            this.m_errorState.setError(error);
        }
    }
}

