/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.lzma;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.at4j.comp.lzma.LzmaOutputStream;
import org.at4j.comp.lzma.LzmaOutputStreamSettings;
import org.entityfs.WritableFile;
import org.entityfs.exception.LockTimeoutException;
import org.entityfs.exception.ReadOnlyException;
import org.entityfs.lock.EntityLock;
import org.entityfs.lock.WriteLockRequiredException;
import org.entityfs.security.AccessDeniedException;
import org.entityfs.support.exception.WrappedIOException;

public class LzmaWritableFile
implements WritableFile {
    private final WritableFile m_adapted;
    private final LzmaOutputStreamSettings m_settings;

    public LzmaWritableFile(WritableFile writableFile) {
        writableFile.getClass();
        this.m_adapted = writableFile;
        this.m_settings = null;
    }

    public LzmaWritableFile(WritableFile writableFile, LzmaOutputStreamSettings lzmaOutputStreamSettings) {
        writableFile.getClass();
        this.m_adapted = writableFile;
        this.m_settings = lzmaOutputStreamSettings;
    }

    public WritableByteChannel openChannelForAppend() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Appending to LZMA compressed files is not supported");
    }

    public WritableByteChannel openChannelForWrite() throws WriteLockRequiredException, AccessDeniedException, ReadOnlyException {
        return Channels.newChannel(this.openForWrite());
    }

    public OutputStream openForAppend() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Appending to LZMA compressed files is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream openForWrite() throws WriteLockRequiredException, AccessDeniedException, ReadOnlyException {
        LzmaOutputStream lzmaOutputStream;
        block6: {
            boolean bl = false;
            BufferedOutputStream bufferedOutputStream = this.m_settings == null || this.m_settings.getBufferSize() == -1 ? new BufferedOutputStream(this.m_adapted.openForWrite()) : new BufferedOutputStream(this.m_adapted.openForWrite(), this.m_settings.getBufferSize());
            try {
                LzmaOutputStream lzmaOutputStream2 = this.m_settings != null ? new LzmaOutputStream(bufferedOutputStream, this.m_settings) : new LzmaOutputStream(bufferedOutputStream);
                bl = true;
                lzmaOutputStream = lzmaOutputStream2;
                if (bl) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (!bl) {
                        ((OutputStream)bufferedOutputStream).close();
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new WrappedIOException(iOException);
                }
            }
            ((OutputStream)bufferedOutputStream).close();
        }
        return lzmaOutputStream;
    }

    public EntityLock getWriteLock() {
        return this.m_adapted.getWriteLock();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.m_adapted.isWriteLockedByCurrentThread();
    }

    public EntityLock lockForWriting() throws LockTimeoutException {
        return this.m_adapted.lockForWriting();
    }
}

