/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.lzma;

import SevenZip.Compression.LZMA.Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.at4j.comp.lzma.LzmaEncoderInputStream;
import org.at4j.comp.lzma.LzmaErrorState;
import org.at4j.comp.lzma.LzmaOutputStreamSettings;
import org.at4j.support.lang.SignedLong;

final class LzmaWriterRunnable
implements Runnable {
    private final LzmaErrorState m_errorState;
    private final Encoder m_encoder;
    private final LzmaOutputStreamSettings m_settings;
    private final long m_uncompressedDataSize;
    private final LzmaEncoderInputStream m_queueStream;
    private final OutputStream m_outStream;

    LzmaWriterRunnable(LzmaEncoderInputStream lzmaEncoderInputStream, Encoder encoder, LzmaOutputStreamSettings lzmaOutputStreamSettings, long l, LzmaErrorState lzmaErrorState, OutputStream outputStream) {
        this.m_errorState = lzmaErrorState;
        this.m_encoder = encoder;
        this.m_settings = lzmaOutputStreamSettings;
        this.m_uncompressedDataSize = l;
        this.m_queueStream = lzmaEncoderInputStream;
        this.m_outStream = outputStream;
    }

    public void run() {
        try {
            if (this.m_settings.isWriteStreamProperties()) {
                this.m_encoder.WriteCoderProperties(this.m_outStream);
            }
            if (this.m_settings.isWriteUncompressedDataSize()) {
                this.m_outStream.write(SignedLong.valueOf(this.m_uncompressedDataSize).getBigEndianByteArray());
            }
            this.m_encoder.Code((InputStream)this.m_queueStream, this.m_outStream, -1L, -1L, null);
        }
        catch (Error error) {
            this.m_errorState.setError(error);
        }
        catch (RuntimeException runtimeException) {
            this.m_errorState.setRuntimeException(runtimeException);
        }
        catch (IOException iOException) {
            this.m_errorState.setIoException(iOException);
        }
    }
}

