/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.lzma.prog;

import SevenZip.Compression.LZMA.Decoder;
import SevenZip.Compression.LZMA.Encoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.at4j.comp.lzma.prog.AbstractLzmaCommandLineArguments;
import org.at4j.comp.prog.IgnoreFileException;
import org.at4j.support.lang.SignedLong;
import org.at4j.support.lang.UnsignedLong;
import org.at4j.support.prog.AbstractProgram;
import org.at4j.support.prog.CommandErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractLzmaProgram<T extends AbstractLzmaCommandLineArguments>
extends AbstractProgram {
    private static final int STREAM_PROPERTIES_SIZE = 5;

    AbstractLzmaProgram() {
    }

    private File getTargetFile(File file, T t) throws IgnoreFileException {
        String string = file.getName();
        String string2 = ((AbstractLzmaCommandLineArguments)t).getCompressedFileSuffix();
        if (!string.toLowerCase().endsWith(string2)) {
            throw new IgnoreFileException(string + " does not end with " + string2);
        }
        return new File(file.getParentFile(), string.substring(0, string.length() - string2.length()));
    }

    private void deleteSource(File file, T t) {
        if (!((AbstractLzmaCommandLineArguments)t).isDontDeleteSourceFile() && !file.delete()) {
            System.err.println("Could not delete " + file + ". No reason given.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompress(T t) throws CommandErrorException, IOException, InterruptedException {
        for (File file : ((AbstractLzmaCommandLineArguments)t).getSources()) {
            try {
                File file2 = this.getTargetFile(file, t);
                if (file2.exists()) {
                    throw new IgnoreFileException(file2 + " already exists");
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                try {
                    FilterOutputStream filterOutputStream = ((AbstractLzmaCommandLineArguments)t).isWriteToStdout() ? System.out : new BufferedOutputStream(new FileOutputStream(file2));
                    try {
                        byte[] byArray = new byte[5];
                        int n = ((InputStream)bufferedInputStream).read(byArray);
                        if (n != 5) {
                            throw new IOException("Wanted to read 5 bytes. Got " + n);
                        }
                        Decoder decoder = new Decoder();
                        long l = UnsignedLong.readBigEndian(bufferedInputStream).longValue();
                        if (!decoder.SetDecoderProperties(byArray, l)) {
                            throw new IOException("Could not set LZMA decoder properties from the data in the supplied stream. No reason given.");
                        }
                        if (!decoder.Code((InputStream)bufferedInputStream, (OutputStream)filterOutputStream, l)) {
                            throw new IOException("Could not decode " + file + " No reason given.");
                        }
                    }
                    finally {
                        ((OutputStream)filterOutputStream).close();
                    }
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
                this.deleteSource(file, t);
            }
            catch (IgnoreFileException ignoreFileException) {
                System.err.println("Ignoring " + file + ": " + ignoreFileException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compress(T t) throws CommandErrorException, IOException, InterruptedException {
        for (File file : ((AbstractLzmaCommandLineArguments)t).getSources()) {
            File file2 = new File(file.getParentFile(), file.getName() + ((AbstractLzmaCommandLineArguments)t).getCompressedFileSuffix());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                FilterOutputStream filterOutputStream = ((AbstractLzmaCommandLineArguments)t).isWriteToStdout() ? System.out : new BufferedOutputStream(new FileOutputStream(file2));
                try {
                    Encoder encoder = new Encoder();
                    encoder.WriteCoderProperties((OutputStream)filterOutputStream);
                    ((OutputStream)filterOutputStream).write(SignedLong.valueOf(file.length()).getBigEndianByteArray());
                    encoder.Code((InputStream)bufferedInputStream, (OutputStream)filterOutputStream, -1L, -1L, null);
                }
                finally {
                    ((OutputStream)filterOutputStream).close();
                }
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
            this.deleteSource(file, t);
        }
    }

    abstract T parseCommandLine(String[] var1) throws CommandErrorException;

    abstract boolean isDecompress(T var1);

    void run(String[] stringArray) throws CommandErrorException, IOException, InterruptedException {
        T t = this.parseCommandLine(stringArray);
        long l = System.currentTimeMillis();
        if (this.isDecompress(t)) {
            this.decompress(t);
        } else {
            this.compress(t);
        }
        long l2 = System.currentTimeMillis();
        if (((AbstractLzmaCommandLineArguments)t).isTiming()) {
            System.out.println("The operation took " + (l2 - l) + " ms.");
            System.out.println("The time it took to load Java and start the program is not included.");
        }
    }
}

