/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.lzma.prog;

import java.io.File;
import java.io.IOException;
import org.at4j.comp.lzma.prog.AbstractLzmaProgram;
import org.at4j.comp.lzma.prog.LzmaCommandLineArguments;
import org.at4j.support.prog.CommandErrorException;
import org.entityfs.support.exception.WrappedIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Lzma
extends AbstractLzmaProgram<LzmaCommandLineArguments> {
    @Override
    LzmaCommandLineArguments parseCommandLine(String[] stringArray) throws CommandErrorException {
        LzmaCommandLineArguments lzmaCommandLineArguments = new LzmaCommandLineArguments();
        int n = 0;
        String string = this.getArg(stringArray, n++, "Missing files");
        while (this.isFlagArgument(string)) {
            if ("--timing".equals(string)) {
                lzmaCommandLineArguments.setTiming();
            } else if ("-c".equals(string)) {
                lzmaCommandLineArguments.setWriteToStdout();
                lzmaCommandLineArguments.setDontDeleteSourceFile();
            } else if ("-S".equals(string) || "--suffix".equals(string)) {
                lzmaCommandLineArguments.setCompressedFileSuffix(this.getArg(stringArray, n++, "Missing compressed file suffix"));
            } else if ("-d".equals(string) || "--decompress".equals(string) || "--uncompress".equals(string)) {
                lzmaCommandLineArguments.setDecompress();
            } else {
                throw new CommandErrorException("Unknown argument " + string);
            }
            string = this.getArg(stringArray, n++, "Missing files");
        }
        lzmaCommandLineArguments.addSource(new File(string));
        while (n < stringArray.length) {
            string = stringArray[n++];
            lzmaCommandLineArguments.addSource(new File(string));
        }
        return lzmaCommandLineArguments;
    }

    @Override
    boolean isDecompress(LzmaCommandLineArguments lzmaCommandLineArguments) {
        return lzmaCommandLineArguments.isDecompress();
    }

    public static void main(String[] stringArray) throws InterruptedException {
        try {
            new Lzma().run(stringArray);
        }
        catch (CommandErrorException commandErrorException) {
            System.err.println(commandErrorException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(1);
        }
        catch (WrappedIOException wrappedIOException) {
            System.err.println(wrappedIOException.getMessage());
            System.exit(1);
        }
    }
}

