/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.prog;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.at4j.comp.prog.IgnoreFileException;
import org.at4j.comp.prog.StreamCompressionProgramArguments;
import org.at4j.support.prog.AbstractProgram;
import org.at4j.support.prog.CommandErrorException;
import org.entityfs.support.io.StreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStreamCompressionProgram<T extends StreamCompressionProgramArguments>
extends AbstractProgram {
    protected abstract T parseCommandLine(String[] var1) throws CommandErrorException;

    protected abstract InputStream createInputStream(int var1, T var2) throws IOException, IgnoreFileException;

    protected abstract OutputStream createOutputStream(int var1, T var2) throws IOException, IgnoreFileException;

    protected void postProcess(int n, T t) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(int n, T t) throws IOException, IgnoreFileException {
        InputStream inputStream = this.createInputStream(n, t);
        try {
            OutputStream outputStream = this.createOutputStream(n, t);
            try {
                StreamUtil.copyStreams((InputStream)inputStream, (OutputStream)outputStream, (int)8192);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
        this.postProcess(n, t);
    }

    private void runSingleThread(T t) throws IOException {
        for (int i = 0; i < ((StreamCompressionProgramArguments)t).getNumberOfSources(); ++i) {
            try {
                this.processFile(i, t);
                continue;
            }
            catch (IgnoreFileException ignoreFileException) {
                System.err.println(ignoreFileException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMultipleThreads(T t) throws IOException {
        ErrorState errorState = new ErrorState();
        int n = ((StreamCompressionProgramArguments)t).getNumberOfSources();
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(n, ((StreamCompressionProgramArguments)t).getNumberOfThreads()));
        try {
            for (int i = 0; i < n; ++i) {
                executorService.submit(new ProcessRunnable(this, i, (StreamCompressionProgramArguments)t, errorState));
            }
        }
        finally {
            executorService.shutdown();
        }
        try {
            executorService.awaitTermination(1000000000000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        Throwable throwable = errorState.getException();
        if (throwable != null) {
            throw new RuntimeException(throwable);
        }
    }

    protected void run(String[] stringArray) throws CommandErrorException, IOException {
        T t = this.parseCommandLine(stringArray);
        long l = System.currentTimeMillis();
        if (((StreamCompressionProgramArguments)t).getNumberOfThreads() == 1) {
            this.runSingleThread(t);
        } else {
            this.runMultipleThreads(t);
        }
        long l2 = System.currentTimeMillis();
        if (((StreamCompressionProgramArguments)t).isTiming()) {
            System.out.println("The operation took " + (l2 - l) + " ms.");
            System.out.println("The time it took to load Java and start the program is not included.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessRunnable
    implements Runnable {
        private final int m_sourceNo;
        private final T m_settings;
        private final ErrorState m_errState;
        final /* synthetic */ AbstractStreamCompressionProgram this$0;

        private ProcessRunnable(int n, T t, ErrorState errorState) {
            this.this$0 = var1_1;
            this.m_sourceNo = n;
            this.m_settings = t;
            this.m_errState = errorState;
        }

        @Override
        public void run() {
            if (this.m_errState.hasException()) {
                return;
            }
            try {
                this.this$0.processFile(this.m_sourceNo, this.m_settings);
            }
            catch (IgnoreFileException ignoreFileException) {
                System.err.println(ignoreFileException.getMessage());
            }
            catch (IOException iOException) {
                this.m_errState.setException(iOException);
            }
            catch (RuntimeException runtimeException) {
                this.m_errState.setException(runtimeException);
            }
        }
    }

    private static class ErrorState {
        private Throwable m_exception;

        private ErrorState() {
        }

        private synchronized boolean hasException() {
            return this.m_exception != null;
        }

        private synchronized Throwable getException() {
            return this.m_exception;
        }

        private synchronized void setException(Throwable throwable) {
            this.m_exception = throwable;
        }
    }
}

