/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.comp;

public class ByteMoveToFront {
    private final byte[] m_alphabet;

    private static byte[] createByteAlphabetFromRange(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n2 > 255 || n >= n2) {
            throw new IndexOutOfBoundsException("Invalid min and/or max value: min " + n + ", max " + n2);
        }
        int n3 = n2 - n + 1;
        byte[] byArray = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            byArray[i] = (byte)(i + n & 0xFF);
        }
        return byArray;
    }

    public ByteMoveToFront(int n, int n2) throws IndexOutOfBoundsException {
        this(ByteMoveToFront.createByteAlphabetFromRange(n, n2));
    }

    public ByteMoveToFront(byte[] byArray) {
        byArray.getClass();
        this.m_alphabet = byArray;
    }

    public byte[] encode(byte[] byArray, byte[] byArray2) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (byArray2.length < byArray.length) {
            throw new IllegalArgumentException("The output array must be at least of the same length as the input array. Was in: " + byArray.length + ", out: " + byArray2.length);
        }
        block0: for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (this.m_alphabet[0] == by) {
                byArray2[i] = 0;
                continue;
            }
            byte by2 = this.m_alphabet[0];
            int n = 1;
            while (true) {
                byte by3 = this.m_alphabet[n];
                if (this.m_alphabet[n] == by) {
                    byArray2[i] = (byte)(n & 0xFF);
                    this.m_alphabet[0] = this.m_alphabet[n];
                    this.m_alphabet[n] = by2;
                    continue block0;
                }
                this.m_alphabet[n] = by2;
                by2 = by3;
                ++n;
            }
        }
        return byArray2;
    }

    public byte decode(int n) {
        byte by = this.m_alphabet[n];
        for (int i = n; i > 0; --i) {
            this.m_alphabet[i] = this.m_alphabet[i - 1];
        }
        this.m_alphabet[0] = by;
        return by;
    }

    public byte[] decode(byte[] byArray, byte[] byArray2) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (byArray2.length < byArray.length) {
            throw new IllegalArgumentException("The output array must be at least of the same length as the input array. Was in: " + byArray.length + ", out: " + byArray2.length);
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = this.decode(byArray[i]);
        }
        return byArray2;
    }
}

