/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.io;

import java.io.IOException;
import java.io.InputStream;
import org.at4j.support.io.BitInput;

public class LittleEndianBitInputStream
extends InputStream
implements BitInput {
    private static final int POINTER_START_OF_BYTE = 0;
    private static final int POINTER_END_OF_BYTE = 7;
    private final InputStream m_in;
    private int m_curByte;
    private int m_pointerInByte = 0;
    private long m_numberOfBytesRead = 0L;

    public LittleEndianBitInputStream(InputStream inputStream) throws IOException {
        inputStream.getClass();
        this.m_in = inputStream;
        this.m_curByte = inputStream.read();
    }

    private int readByte() throws IOException {
        int n = this.m_in.read();
        this.m_numberOfBytesRead += n != -1 ? 1L : 0L;
        return n;
    }

    private void incrementPointerPosition() throws IOException {
        if (this.m_pointerInByte == 7) {
            this.m_curByte = this.readByte();
            this.m_pointerInByte = 0;
        } else if (!this.isAtEof()) {
            ++this.m_pointerInByte;
        }
    }

    public boolean isAtEof() {
        return this.m_curByte == -1;
    }

    public long getNumberOfBytesRead() {
        return this.m_numberOfBytesRead;
    }

    private void assertNotAtEOF() throws IOException {
        if (this.isAtEof()) {
            this.throwIOException("At EOF");
        }
    }

    private boolean isAtByteBoundary() {
        return this.m_pointerInByte == 0;
    }

    private void assertAtByteBoundary() throws IOException {
        if (!this.isAtByteBoundary()) {
            this.throwIOException("Not at byte boundary. Position: pos=" + this.m_pointerInByte);
        }
    }

    private void throwIOException(String string, long l) throws IOException {
        throw new IOException(string + ". Position in stream: " + l);
    }

    private void throwIOException(String string) throws IOException {
        throw new IOException(string + ". Position in stream: " + this.m_numberOfBytesRead);
    }

    public void skipToByteBoundary() throws IOException {
        this.assertNotAtEOF();
        if (this.m_pointerInByte != 0) {
            this.m_pointerInByte = 0;
            this.m_curByte = this.readByte();
        }
    }

    public boolean readBit() throws IOException {
        this.assertNotAtEOF();
        boolean bl = (this.m_curByte & 1 << 7 - this.m_pointerInByte) > 0;
        this.incrementPointerPosition();
        return bl;
    }

    public int readBits(int n) throws IOException, IndexOutOfBoundsException {
        if (n < 0 || n > 8) {
            throw new IndexOutOfBoundsException("Invalid number of bits: " + n + ". Must be between 0 and 8 (inclusive)");
        }
        this.assertNotAtEOF();
        if (n == 0) {
            return 0;
        }
        if (n + this.m_pointerInByte <= 8) {
            int n2 = this.m_curByte >> 8 - n - this.m_pointerInByte & (1 << n) - 1;
            this.m_pointerInByte += n;
            if (this.m_pointerInByte > 7) {
                this.m_curByte = this.readByte();
                this.m_pointerInByte = 0;
            }
            return n2;
        }
        int n3 = n - (8 - this.m_pointerInByte);
        int n4 = (this.m_curByte & (1 << 8 - this.m_pointerInByte) - 1) << n3;
        this.m_curByte = this.readByte();
        this.assertNotAtEOF();
        this.m_pointerInByte = n3;
        return n4 += this.m_curByte >> 8 - n3;
    }

    public int readBitsLittleEndian(int n) throws IOException, IndexOutOfBoundsException {
        if (n < 0 || n > 32) {
            throw new IndexOutOfBoundsException("Invalid number of bits: " + n + ". Must be between 0 and 32 (inclusive)");
        }
        if (n == 0) {
            return 0;
        }
        int n2 = n / 8;
        int n3 = n % 8;
        int n4 = 0;
        if (n3 != 0) {
            n4 = this.readBits(n3) << n2 * 8;
        }
        for (int i = 0; i < n2; ++i) {
            n4 += this.readBits(8) << (n2 - i - 1) * 8;
        }
        return n4;
    }

    public byte[] readBytes(byte[] byArray, int n, int n2) throws IOException, IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Invalid offset " + n + ". It must be >= 0");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Invalid length " + n2 + ". It must be >= 0");
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Invalid offset + length (" + n + " + " + n2 + "). It must be <= the length of the supplied array (" + byArray.length + ")");
        }
        this.assertNotAtEOF();
        if (n2 == 0) {
            return byArray;
        }
        if (this.isAtByteBoundary()) {
            int n3 = this.read(byArray, n, n2);
            if (n3 != n2) {
                this.throwIOException("Unexpected EOF. Wanted to read " + n2 + " bytes. Got " + n3, this.m_numberOfBytesRead - (long)n3);
            }
        } else {
            int n4 = this.m_in.read(byArray, n, n2);
            this.m_numberOfBytesRead += (long)n4;
            if (n4 != n2) {
                this.m_curByte = -1;
                this.m_pointerInByte = 0;
                this.throwIOException("Unexpected EOF. Wanted to read " + n2 + " bytes. Got " + n4, this.m_numberOfBytesRead - (long)n4);
            }
            int n5 = this.m_curByte;
            this.m_curByte = byArray[n + n2 - 1] & 0xFF;
            int n6 = 8 - this.m_pointerInByte;
            for (int i = n; i < n + n2; ++i) {
                int n7 = byArray[i];
                byArray[i] = (byte)((n5 << this.m_pointerInByte | (byArray[i] & 0xFF) >>> n6) & 0xFF);
                n5 = n7;
            }
        }
        return byArray;
    }

    public int read() throws IOException {
        this.assertAtByteBoundary();
        int n = this.m_curByte;
        if (this.m_curByte != -1) {
            this.m_curByte = this.readByte();
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException, IOException {
        int n3;
        if (n < 0) {
            throw new IndexOutOfBoundsException("Illegal offset: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Illegal length: " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Illegal offset + length: " + n + " + " + n2 + ". Longer than the byte array: " + byArray.length);
        }
        this.assertAtByteBoundary();
        if (this.isAtEof()) {
            return -1;
        }
        byArray[n] = (byte)this.m_curByte;
        int n4 = 1;
        if (n2 > 1 && (n3 = this.m_in.read(byArray, n + 1, n2 - 1)) > 0) {
            n4 += n3;
            this.m_numberOfBytesRead += (long)n3;
        }
        this.m_curByte = this.readByte();
        return n4;
    }

    public long skip(long l) throws IOException {
        this.assertAtByteBoundary();
        if (l <= 0L) {
            return 0L;
        }
        if (this.isAtEof()) {
            return 0L;
        }
        if (l > 1L) {
            long l2 = l - 1L;
            long l3 = this.m_in.skip(l2);
            this.m_numberOfBytesRead += l3;
            if (l3 < l2) {
                this.m_curByte = -1;
                return l3 + 1L;
            }
            this.m_curByte = this.readByte();
            return l3 + 1L;
        }
        this.m_curByte = this.readByte();
        return 1L;
    }

    public int available() throws IOException {
        this.assertAtByteBoundary();
        return this.m_in.available() + this.m_curByte != -1 ? 1 : 0;
    }

    public void close() throws IOException {
        this.m_in.close();
    }
}

