/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.io;

import java.io.IOException;
import java.io.OutputStream;
import org.at4j.support.io.BitOutput;

public class LittleEndianBitOutputStream
extends OutputStream
implements BitOutput {
    private static final int POINTER_START_OF_BYTE = 0;
    private static final int POINTER_END_OF_BYTE = 7;
    private final OutputStream m_out;
    private int m_curByte = 0;
    private int m_pointerInByte = 0;
    private long m_numberOfBytesWritten = 0L;

    public LittleEndianBitOutputStream(OutputStream outputStream) {
        outputStream.getClass();
        this.m_out = outputStream;
    }

    private boolean isAtByteBoundary() {
        return this.m_pointerInByte == 0;
    }

    private void assertAtByteBoundary() throws IOException {
        if (!this.isAtByteBoundary()) {
            this.throwIOException("Not at byte boundary. Position: pos=" + this.m_pointerInByte);
        }
    }

    private void throwIOException(String string) throws IOException {
        throw new IOException(string + ". Position in stream: " + this.m_numberOfBytesWritten);
    }

    private void writeCurByte() throws IOException {
        this.m_out.write(this.m_curByte);
        ++this.m_numberOfBytesWritten;
        this.m_pointerInByte = 0;
        this.m_curByte = 0;
    }

    public long getNumberOfBytesWritten() {
        return this.m_numberOfBytesWritten;
    }

    public int getUnfinishedByte() {
        return this.m_pointerInByte > 0 ? this.m_curByte >>> 7 - (this.m_pointerInByte - 1) : 0;
    }

    public int getNumberOfBitsInUnfinishedByte() {
        return this.m_pointerInByte;
    }

    public void padToByteBoundary() throws IOException {
        if (this.m_pointerInByte > 0) {
            this.writeCurByte();
        }
    }

    public void writeBit(boolean bl) throws IOException {
        if (bl) {
            this.m_curByte |= 1 << 7 - this.m_pointerInByte;
        }
        ++this.m_pointerInByte;
        if (this.m_pointerInByte > 7) {
            this.writeCurByte();
        }
    }

    public void writeBits(int n, int n2) throws IOException, IndexOutOfBoundsException {
        if (n2 < 0 || n2 > 8) {
            throw new IndexOutOfBoundsException("Invalid number of bits " + n2 + ". Must be between 0 and 8 (inclusive)");
        }
        if (n2 == 0) {
            return;
        }
        if (this.m_pointerInByte + n2 <= 8) {
            this.m_curByte |= (n & (1 << n2) - 1) << 8 - this.m_pointerInByte - n2;
            this.m_pointerInByte += n2;
            if (this.m_pointerInByte > 7) {
                this.writeCurByte();
            }
        } else {
            int n3 = 8 - this.m_pointerInByte;
            int n4 = n2 - n3;
            this.m_curByte |= n >>> n2 - n3;
            this.writeCurByte();
            this.m_curByte = (n & (1 << n4) - 1) << 8 - n4;
            this.m_pointerInByte = n4;
        }
    }

    public void writeBitsLittleEndian(int n, int n2) throws IndexOutOfBoundsException, IOException {
        if (n2 < 0 || n2 > 32) {
            throw new IndexOutOfBoundsException("Invalid number of bits to write " + n2 + ". It must be between 0 and 32 (inclusive)");
        }
        if (n2 == 0) {
            return;
        }
        int n3 = n2 / 8;
        int n4 = n2 % 8;
        if (n4 != 0) {
            this.writeBits(n >>> n3 * 8, n4);
        }
        for (int i = 0; i < n3; ++i) {
            this.writeBits(n >>> (n3 - i - 1) * 8, 8);
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException, IOException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Invalid offset " + n + ". It must be >= 0");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Invalid length " + n2 + ". It must be >= 0");
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Invalid offset + length (" + n + " + " + n2 + "). It must be <= the length of the supplied array (" + byArray.length + ")");
        }
        if (n2 == 0) {
            return;
        }
        if (this.isAtByteBoundary()) {
            this.m_out.write(byArray, n, n2);
            this.m_numberOfBytesWritten += (long)n2;
        } else {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            int n3 = this.m_curByte;
            int n4 = 8 - this.m_pointerInByte;
            for (int i = 0; i < n2; ++i) {
                int n5 = (byArray2[i] & 0xFF) << n4;
                byArray2[i] = (byte)((n3 | (byArray2[i] & 0xFF) >>> this.m_pointerInByte) & 0xFF);
                n3 = n5;
            }
            this.m_curByte = n3 & 0xFF;
            this.m_out.write(byArray2);
            this.m_numberOfBytesWritten += (long)n2;
        }
    }

    public void write(int n) throws IOException {
        this.assertAtByteBoundary();
        this.m_out.write(n);
        ++this.m_numberOfBytesWritten;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.assertAtByteBoundary();
        this.m_out.write(byArray, n, n2);
        this.m_numberOfBytesWritten += (long)n2;
    }

    public void close() throws IOException {
        this.m_out.close();
        super.close();
    }
}

