/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignedInteger
implements Comparable<SignedInteger> {
    public static final SignedInteger ZERO = new SignedInteger(0);
    public static final SignedInteger ONE = new SignedInteger(1);
    private final int m_value;

    private SignedInteger(int n) {
        this.m_value = n;
    }

    public static SignedInteger valueOf(int n) {
        if (n == 0) {
            return ZERO;
        }
        if (n == 1) {
            return ONE;
        }
        return new SignedInteger(n);
    }

    public long intValue() {
        return this.m_value;
    }

    public byte[] getBigEndianByteArray() {
        byte[] byArray = new byte[]{(byte)this.m_value, (byte)(this.m_value >> 8), (byte)(this.m_value >> 16), (byte)(this.m_value >> 24)};
        return byArray;
    }

    public static SignedInteger fromBigEndianByteArray(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Illegal size of supplied byte array: " + byArray.length + ". It must be four bytes long");
        }
        int n = byArray[0] & 0xFF;
        n = (int)((long)n + (((long)byArray[1] & 0xFFL) << 8));
        n = (int)((long)n + (((long)byArray[2] & 0xFFL) << 16));
        n = (int)((long)n + (((long)byArray[3] & 0xFFL) << 24));
        return SignedInteger.valueOf(n);
    }

    public byte[] getLittleEndianByteArray() {
        byte[] byArray = new byte[]{(byte)(this.m_value >> 24), (byte)(this.m_value >> 16), (byte)(this.m_value >> 8), (byte)this.m_value};
        return byArray;
    }

    public static SignedInteger fromLittleEndianByteArray(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Illegal size of supplied byte array: " + byArray.length + ". It must be four bytes long");
        }
        int n = byArray[3] & 0xFF;
        n = (int)((long)n + (((long)byArray[2] & 0xFFL) << 8));
        n = (int)((long)n + (((long)byArray[1] & 0xFFL) << 16));
        n = (int)((long)n + (((long)byArray[0] & 0xFFL) << 24));
        return SignedInteger.valueOf(n);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SignedInteger) {
            return this.m_value == ((SignedInteger)object).m_value;
        }
        return false;
    }

    public int hashCode() {
        return this.m_value;
    }

    @Override
    public int compareTo(SignedInteger signedInteger) {
        return Integer.valueOf(this.m_value).compareTo(signedInteger.m_value);
    }

    public String toString() {
        return "" + this.m_value;
    }
}

