/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignedLong
implements Comparable<SignedLong> {
    public static final SignedLong ZERO = new SignedLong(0L);
    public static final SignedLong ONE = new SignedLong(1L);
    private final long m_value;

    private SignedLong(long l) {
        this.m_value = l;
    }

    public static SignedLong valueOf(long l) {
        if (l == 0L) {
            return ZERO;
        }
        if (l == 1L) {
            return ONE;
        }
        return new SignedLong(l);
    }

    public long longValue() {
        return this.m_value;
    }

    public byte[] getBigEndianByteArray() {
        byte[] byArray = new byte[]{(byte)this.m_value, (byte)(this.m_value >> 8), (byte)(this.m_value >> 16), (byte)(this.m_value >> 24), (byte)(this.m_value >> 32), (byte)(this.m_value >> 40), (byte)(this.m_value >> 48), (byte)(this.m_value >> 56)};
        return byArray;
    }

    public static SignedLong fromBigEndianByteArray(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length != 8) {
            throw new IllegalArgumentException("Illegal size of supplied byte array: " + byArray.length + ". It must be eight bytes long");
        }
        long l = byArray[0] & 0xFF;
        l += ((long)byArray[1] & 0xFFL) << 8;
        l += ((long)byArray[2] & 0xFFL) << 16;
        l += ((long)byArray[3] & 0xFFL) << 24;
        l += ((long)byArray[4] & 0xFFL) << 32;
        l += ((long)byArray[5] & 0xFFL) << 40;
        l += ((long)byArray[6] & 0xFFL) << 48;
        return SignedLong.valueOf(l += ((long)byArray[7] & 0xFFL) << 56);
    }

    public byte[] getLittleEndianByteArray() {
        byte[] byArray = new byte[]{(byte)(this.m_value >> 56), (byte)(this.m_value >> 48), (byte)(this.m_value >> 40), (byte)(this.m_value >> 32), (byte)(this.m_value >> 24), (byte)(this.m_value >> 16), (byte)(this.m_value >> 8), (byte)this.m_value};
        return byArray;
    }

    public static SignedLong fromLittleEndianByteArray(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length != 8) {
            throw new IllegalArgumentException("Illegal size of supplied byte array: " + byArray.length + ". It must be eight bytes long");
        }
        long l = byArray[7] & 0xFF;
        l += ((long)byArray[6] & 0xFFL) << 8;
        l += ((long)byArray[5] & 0xFFL) << 16;
        l += ((long)byArray[4] & 0xFFL) << 24;
        l += ((long)byArray[3] & 0xFFL) << 32;
        l += ((long)byArray[2] & 0xFFL) << 40;
        l += ((long)byArray[1] & 0xFFL) << 48;
        return SignedLong.valueOf(l += ((long)byArray[0] & 0xFFL) << 56);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SignedLong) {
            return this.m_value == ((SignedLong)object).m_value;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.m_value ^ this.m_value >>> 32);
    }

    @Override
    public int compareTo(SignedLong signedLong) {
        return Long.valueOf(this.m_value).compareTo(signedLong.m_value);
    }

    public String toString() {
        return "" + this.m_value;
    }
}

