/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.entityfs.RandomAccess;
import org.entityfs.exception.UnexpectedEofException;
import org.entityfs.support.exception.WrappedIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnsignedByte
implements Serializable,
Comparable<UnsignedByte> {
    private static final long serialVersionUID = 1L;
    public static final short MAX_VALUE = 255;
    public static final short MIN_VALUE = 0;
    public static final UnsignedByte ZERO = new UnsignedByte(0);
    public static final UnsignedByte ONE = new UnsignedByte(1);
    private final byte m_value;

    private UnsignedByte(byte by) {
        this.m_value = by;
    }

    public static UnsignedByte valueOf(byte by) {
        switch (by) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
        }
        return new UnsignedByte(by);
    }

    private static UnsignedByte valueOfSafe(int n) {
        return UnsignedByte.valueOf((byte)(n & 0xFF));
    }

    public static UnsignedByte valueOf(short s) throws IllegalArgumentException {
        if (s < 0 || s > 255) {
            throw new IllegalArgumentException("Illegal unsigned byte value " + s + ". It must be between " + 0 + " and " + 255 + " (inclusive)");
        }
        return UnsignedByte.valueOf((byte)(s & 0xFF));
    }

    public static UnsignedByte valueOf(int n) throws IllegalArgumentException {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Illegal unsigned byte value " + n + ". It must be between " + 0 + " and " + 255 + " (inclusive)");
        }
        return UnsignedByte.valueOf((byte)(n & 0xFF));
    }

    public int intValue() {
        return this.m_value & 0xFF;
    }

    public short shortValue() {
        return (short)(this.m_value & 0xFF);
    }

    public byte byteValue() {
        return this.m_value;
    }

    public boolean isBitSet(int n) throws IllegalArgumentException {
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("Invalid bit number " + n + ". It must be between 0 and 7 (inclusive)");
        }
        return (this.m_value & 1 << n) > 0;
    }

    public static UnsignedByte read(RandomAccess randomAccess) throws UnexpectedEofException, WrappedIOException {
        int n = randomAccess.read();
        if (n < 0) {
            throw new UnexpectedEofException("Wanted to read a byte. Got none");
        }
        return UnsignedByte.valueOfSafe(n);
    }

    public static UnsignedByte read(InputStream inputStream) throws UnexpectedEofException, WrappedIOException {
        try {
            int n = inputStream.read();
            if (n < 0) {
                throw new UnexpectedEofException("Wanted to read a byte. Got none");
            }
            return UnsignedByte.valueOfSafe(n);
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
    }

    public boolean equals(Object object) {
        return object instanceof UnsignedByte && ((UnsignedByte)object).m_value == this.m_value;
    }

    public int hashCode() {
        return this.m_value;
    }

    @Override
    public int compareTo(UnsignedByte unsignedByte) {
        return this.intValue() - unsignedByte.intValue();
    }

    public String toString() {
        return Short.toString((short)(this.m_value & 0xFF));
    }
}

