/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.entityfs.RandomAccess;
import org.entityfs.exception.UnexpectedEofException;
import org.entityfs.support.exception.WrappedIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnsignedInteger
implements Serializable,
Comparable<UnsignedInteger> {
    private static final long serialVersionUID = 1L;
    public static final int SIZE = 4;
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final int MIN_VALUE = 0;
    public static final UnsignedInteger ZERO = new UnsignedInteger(0);
    public static final UnsignedInteger ONE = new UnsignedInteger(1);
    private final int m_value;

    private UnsignedInteger(int n) {
        this.m_value = n;
    }

    public static UnsignedInteger valueOf(int n) {
        switch (n) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
        }
        return new UnsignedInteger(n);
    }

    public static UnsignedInteger valueOf(long l) throws IllegalArgumentException {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Illegal unsigned integer value " + l + ". It must be between " + 0 + " and " + 0xFFFFFFFFL + " (inclusive)");
        }
        return UnsignedInteger.valueOf((int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    public long longValue() {
        return (long)this.m_value & 0xFFFFFFFFL;
    }

    public int intValue() {
        return this.m_value;
    }

    public byte[] getBigEndianByteArray() {
        byte[] byArray = new byte[]{(byte)(this.m_value & 0xFF), (byte)(this.m_value >>> 8 & 0xFF), (byte)(this.m_value >>> 16 & 0xFF), (byte)(this.m_value >>> 24 & 0xFF)};
        return byArray;
    }

    public static UnsignedInteger fromBigEndianByteArray(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("The supplied byte array must be four bytes long");
        }
        return UnsignedInteger.fromBigEndianByteArray(byArray, 0);
    }

    public static UnsignedInteger fromBigEndianByteArray(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        return UnsignedInteger.valueOf((byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 24));
    }

    public static long fromBigEndianByteArrayToLong(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        return (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 24);
    }

    public static long fromLittleEndianByteArrayToLong(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        return (byArray[n + 3] & 0xFF) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n] & 0xFF) << 24);
    }

    public static UnsignedInteger readBigEndian(RandomAccess randomAccess) throws UnexpectedEofException, WrappedIOException {
        byte[] byArray = new byte[4];
        int n = randomAccess.read(byArray);
        if (n != 4) {
            throw new UnexpectedEofException("Wanted to read 4 bytes. Got " + n);
        }
        return UnsignedInteger.fromBigEndianByteArray(byArray);
    }

    public static UnsignedInteger readBigEndian(InputStream inputStream) throws UnexpectedEofException, WrappedIOException {
        byte[] byArray = new byte[4];
        try {
            int n = inputStream.read(byArray);
            if (n != 4) {
                throw new UnexpectedEofException("Wanted to read 4 bytes. Got " + n);
            }
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
        return UnsignedInteger.fromBigEndianByteArray(byArray);
    }

    public boolean equals(Object object) {
        return object instanceof UnsignedInteger && ((UnsignedInteger)object).m_value == this.m_value;
    }

    public int hashCode() {
        return this.m_value;
    }

    @Override
    public int compareTo(UnsignedInteger unsignedInteger) {
        return Long.valueOf(this.longValue()).compareTo(unsignedInteger.longValue());
    }

    public String toString() {
        return Long.toString((long)this.m_value & 0xFFFFFFFFL);
    }
}

