/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import org.entityfs.RandomAccess;
import org.entityfs.exception.UnexpectedEofException;
import org.entityfs.support.exception.WrappedIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnsignedLong
implements Serializable,
Comparable<UnsignedLong> {
    private static final long serialVersionUID = 1L;
    public static final BigInteger MIN_VALUE = BigInteger.valueOf(0L);
    public static final BigInteger MAX_VALUE;
    public static final UnsignedLong ZERO;
    public static final UnsignedLong ONE;
    private static final BigInteger HIGHEST_BIT_VALUE;
    private final long m_value;

    private UnsignedLong(long l) {
        this.m_value = l;
    }

    public static UnsignedLong valueOf(long l) {
        if (l == 0L) {
            return ZERO;
        }
        if (l == 1L) {
            return ONE;
        }
        return new UnsignedLong(l);
    }

    public static UnsignedLong valueOf(BigInteger bigInteger) throws IllegalArgumentException {
        if (bigInteger.compareTo(MIN_VALUE) < 0 || bigInteger.compareTo(MAX_VALUE) > 0) {
            throw new IllegalArgumentException("Illegal unsigned long value " + bigInteger + ". It must be between 0 and " + MAX_VALUE + " (inclusive)");
        }
        return UnsignedLong.valueOf(bigInteger.longValue());
    }

    public BigInteger bigIntValue() {
        BigInteger bigInteger = BigInteger.valueOf(this.m_value & Long.MAX_VALUE);
        return this.m_value < 0L ? bigInteger.add(HIGHEST_BIT_VALUE) : bigInteger;
    }

    public long longValue() {
        return this.m_value;
    }

    public byte[] getBigEndianByteArray() {
        byte[] byArray = new byte[]{(byte)(this.m_value & 0xFFL), (byte)(this.m_value >>> 8 & 0xFFL), (byte)(this.m_value >>> 16 & 0xFFL), (byte)(this.m_value >>> 24 & 0xFFL), (byte)(this.m_value >>> 32 & 0xFFL), (byte)(this.m_value >>> 40 & 0xFFL), (byte)(this.m_value >>> 48 & 0xFFL), (byte)(this.m_value >>> 56 & 0xFFL)};
        return byArray;
    }

    public static UnsignedLong fromBigEndianByteArray(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length != 8) {
            throw new IllegalArgumentException("The supplied byte array must be eight bytes long");
        }
        return UnsignedLong.fromBigEndianByteArray(byArray, 0);
    }

    public static UnsignedLong fromBigEndianByteArray(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        return UnsignedLong.valueOf(((long)byArray[n] & 0xFFL) + (((long)byArray[n + 1] & 0xFFL) << 8) + (((long)byArray[n + 2] & 0xFFL) << 16) + (((long)byArray[n + 3] & 0xFFL) << 24) + (((long)byArray[n + 4] & 0xFFL) << 32) + (((long)byArray[n + 5] & 0xFFL) << 40) + (((long)byArray[n + 6] & 0xFFL) << 48) + (((long)byArray[n + 7] & 0xFFL) << 56));
    }

    public static UnsignedLong readBigEndian(RandomAccess randomAccess) throws UnexpectedEofException, WrappedIOException {
        byte[] byArray = new byte[8];
        int n = randomAccess.read(byArray);
        if (n != 8) {
            throw new UnexpectedEofException("Wanted to read 8 bytes. Got " + n);
        }
        return UnsignedLong.fromBigEndianByteArray(byArray);
    }

    public static UnsignedLong readBigEndian(InputStream inputStream) throws UnexpectedEofException, WrappedIOException {
        byte[] byArray = new byte[8];
        try {
            int n = inputStream.read(byArray);
            if (n != 8) {
                throw new UnexpectedEofException("Wanted to read 8 bytes. Got " + n);
            }
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
        return UnsignedLong.fromBigEndianByteArray(byArray);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof UnsignedLong) {
            return this.m_value == ((UnsignedLong)object).m_value;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.m_value ^ this.m_value >>> 32);
    }

    @Override
    public int compareTo(UnsignedLong unsignedLong) {
        return this.bigIntValue().compareTo(unsignedLong.bigIntValue());
    }

    public String toString() {
        return this.bigIntValue().toString();
    }

    static {
        ZERO = new UnsignedLong(0L);
        ONE = new UnsignedLong(1L);
        BigInteger bigInteger = BigInteger.valueOf(2L);
        MAX_VALUE = bigInteger.pow(64).subtract(BigInteger.ONE);
        HIGHEST_BIT_VALUE = bigInteger.pow(63);
    }
}

