/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.entityfs.RandomAccess;
import org.entityfs.exception.UnexpectedEofException;
import org.entityfs.support.exception.WrappedIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnsignedShort
implements Serializable,
Comparable<UnsignedShort> {
    private static final long serialVersionUID = 1L;
    public static final int SIZE = 2;
    public static final int MAX_VALUE = 65535;
    public static final int MIN_VALUE = 0;
    public static final UnsignedShort ZERO = new UnsignedShort(0);
    public static final UnsignedShort ONE = new UnsignedShort(1);
    public static final UnsignedShort ONE_THOUSAND = new UnsignedShort(1000);
    private final short m_value;

    private UnsignedShort(short s) {
        this.m_value = s;
    }

    public static UnsignedShort valueOf(short s) {
        switch (s) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 1000: {
                return ONE_THOUSAND;
            }
        }
        return new UnsignedShort(s);
    }

    public static UnsignedShort valueOf(int n) throws IllegalArgumentException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Illegal unsigned short value " + n + ". It must be between " + 0 + " and " + 65535 + " (inclusive)");
        }
        return UnsignedShort.valueOf((short)(n & 0xFFFF));
    }

    public int intValue() {
        return this.m_value & 0xFFFF;
    }

    public byte[] getBigEndianByteArray() {
        byte[] byArray = new byte[]{(byte)(this.m_value & 0xFF), (byte)(this.m_value >>> 8 & 0xFF)};
        return byArray;
    }

    public static UnsignedShort fromBigEndianByteArray(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length != 2) {
            throw new IllegalArgumentException("The supplied byte array must be two bytes long");
        }
        return UnsignedShort.fromBigEndianByteArray(byArray, 0);
    }

    public static UnsignedShort fromBigEndianByteArray(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        return UnsignedShort.valueOf((short)((byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) & 0xFFFF));
    }

    public static UnsignedShort readBigEndian(RandomAccess randomAccess) throws UnexpectedEofException, WrappedIOException {
        byte[] byArray = new byte[2];
        int n = randomAccess.read(byArray);
        if (n != 2) {
            throw new UnexpectedEofException("Wanted to read 2 bytes. Got " + n);
        }
        return UnsignedShort.fromBigEndianByteArray(byArray);
    }

    public static UnsignedShort readBigEndian(InputStream inputStream) throws UnexpectedEofException, WrappedIOException {
        byte[] byArray = new byte[2];
        try {
            int n = inputStream.read(byArray);
            if (n != 2) {
                throw new UnexpectedEofException("Wanted to read 2 bytes. Got " + n);
            }
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
        return UnsignedShort.fromBigEndianByteArray(byArray);
    }

    public boolean equals(Object object) {
        return object instanceof UnsignedShort && ((UnsignedShort)object).m_value == this.m_value;
    }

    public int hashCode() {
        return this.m_value;
    }

    @Override
    public int compareTo(UnsignedShort unsignedShort) {
        return this.intValue() - unsignedShort.intValue();
    }

    public String toString() {
        return Integer.toString(this.m_value & 0xFFFF);
    }
}

