/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.at4j.support.lang.At4JException;

public final class Charsets {
    public static final Charset UTF8 = Charset.forName("utf8");
    public static final Charset UTF16 = Charset.forName("utf16");
    public static final Charset ASCII = Charset.forName("ascii");

    private Charsets() {
    }

    public static byte[] getBytes(String string, Charset charset) throws At4JException {
        ByteBuffer byteBuffer;
        CharsetEncoder charsetEncoder = charset.newEncoder();
        try {
            byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string));
        }
        catch (CharacterCodingException characterCodingException) {
            throw new At4JException(characterCodingException);
        }
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }
}

