/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.util;

import java.util.Calendar;
import org.at4j.support.lang.UnsignedShort;

public final class MsDosDate {
    private MsDosDate() {
    }

    public static void parseMsDosDate(UnsignedShort unsignedShort, Calendar calendar) throws IllegalArgumentException {
        int n = unsignedShort.intValue();
        int n2 = n & 0x1F;
        int n3 = n >> 5 & 0xF;
        int n4 = 1980 + (n >> 9);
        if (n2 == 0) {
            throw new IllegalArgumentException("Invalid MS-DOS date value " + unsignedShort + ". The day of month was " + n2);
        }
        if (n3 == 0 || n3 > 12) {
            throw new IllegalArgumentException("Invalid MS-DOS date value " + unsignedShort + ". The month of year was " + n3);
        }
        calendar.set(5, n2);
        calendar.set(2, n3 - 1);
        calendar.set(1, n4);
    }

    public static UnsignedShort encodeMsDosDate(Calendar calendar) {
        int n = calendar.get(5);
        n += calendar.get(2) + 1 << 5;
        return UnsignedShort.valueOf(n += calendar.get(1) - 1980 << 9);
    }
}

