/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.util;

import java.util.Calendar;
import org.at4j.support.lang.UnsignedShort;

public final class MsDosTime {
    private MsDosTime() {
    }

    public static void parseMsDosTime(UnsignedShort unsignedShort, Calendar calendar) throws IllegalArgumentException {
        int n = unsignedShort.intValue();
        int n2 = 2 * (n & 0x1F);
        int n3 = n >> 5 & 0x3F;
        int n4 = n >> 11;
        if (n3 > 59) {
            throw new IllegalArgumentException("Invalid MS-DOS time value " + unsignedShort + ". The minute was " + n3);
        }
        if (n4 > 23) {
            throw new IllegalArgumentException("Invalid MS-DOS time value " + unsignedShort + ". The hour was " + n4);
        }
        calendar.set(13, n2);
        calendar.set(12, n3);
        calendar.set(11, n4);
    }

    public static UnsignedShort encodeMsDosTime(Calendar calendar) {
        int n = calendar.get(13) / 2;
        n += calendar.get(12) << 5;
        return UnsignedShort.valueOf(n += calendar.get(11) << 11);
    }
}

