/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.util;

import java.io.Serializable;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.at4j.support.lang.UnsignedLong;
import org.at4j.support.util.UnableToConvertException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WinNtTime
implements Serializable,
Comparable<WinNtTime> {
    private static final long serialVersionUID = 1L;
    private static final BigInteger JAVA_TIME_OFFSET = BigInteger.valueOf(11644473600000L);
    private final UnsignedLong m_time;

    public WinNtTime(UnsignedLong unsignedLong) {
        unsignedLong.getClass();
        this.m_time = unsignedLong;
    }

    public WinNtTime(Date date) {
        date.getClass();
        this.m_time = UnsignedLong.valueOf(BigInteger.valueOf(date.getTime()).add(JAVA_TIME_OFFSET).multiply(BigInteger.valueOf(10000L)));
    }

    public UnsignedLong getTime() {
        return this.m_time;
    }

    public Date getDate() throws UnableToConvertException {
        BigInteger bigInteger = this.m_time.bigIntValue().divide(BigInteger.valueOf(10000L)).subtract(JAVA_TIME_OFFSET);
        if (bigInteger.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0 || bigInteger.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            throw new UnableToConvertException("Unable to convert the Windows NT time value " + this + " to a Java Date: the value is outside Date's range");
        }
        return new Date(bigInteger.longValue());
    }

    @Override
    public int compareTo(WinNtTime winNtTime) {
        return this.m_time.compareTo(winNtTime.m_time);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof WinNtTime && ((WinNtTime)object).m_time.equals(this.m_time);
    }

    public int hashCode() {
        return this.m_time.hashCode();
    }

    public String toString() {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS").format(this.getDate());
    }
}

