/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.at4j.tar.TarEntryExtractionStrategy;
import org.at4j.tar.TarEntryHeaderData;
import org.at4j.tar.TarExtractSpecification;
import org.at4j.tar.TarFileParseException;
import org.entityfs.DataSource;
import org.entityfs.Directory;
import org.entityfs.DirectoryView;
import org.entityfs.EFile;
import org.entityfs.ETDirectory;
import org.entityfs.ETFile;
import org.entityfs.EntityType;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.el.RelativeLocation;
import org.entityfs.lock.EntityLock;
import org.entityfs.ostrat.OverwriteResult;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.support.io.StreamUtil;
import org.entityfs.util.Directories;
import org.entityfs.util.io.DataSourceToInputStreamAdapter;

public class ExtractTarEntryExtractionStrategy
implements TarEntryExtractionStrategy {
    private final boolean m_ignoreSymbolicLinks;

    public ExtractTarEntryExtractionStrategy(boolean bl) {
        this.m_ignoreSymbolicLinks = bl;
    }

    protected boolean isIgnoreSymbolicLinks() {
        return this.m_ignoreSymbolicLinks;
    }

    protected Directory getDirectory(Directory directory, AbsoluteLocation absoluteLocation) {
        return (Directory)Directories.putIfAbsentDirectory((DirectoryView)directory, (RelativeLocation)absoluteLocation.getRelativeTo(AbsoluteLocation.ROOT_DIR));
    }

    protected void skipToNextBlockBoundary(DataSource dataSource, long l) {
        if (l > 0L) {
            dataSource.skipBytes(((l - 1L) / 512L + 1L) * 512L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractDirectory(TarEntryHeaderData tarEntryHeaderData, DataSource dataSource, Directory directory, TarExtractSpecification tarExtractSpecification) {
        block9: {
            String string = tarEntryHeaderData.getLocation().getName();
            Directory directory2 = this.getDirectory(directory, tarEntryHeaderData.getLocation().getParentLocation());
            EntityLock entityLock = directory2.lockForWriting();
            try {
                OverwriteResult overwriteResult = tarExtractSpecification.getOverwriteStrategy().overwrite(directory2, string, (EntityType)ETDirectory.TYPE);
                if (overwriteResult == OverwriteResult.CAN_CREATE_NEW_ENTITY) {
                    long l = directory2.getLastModified();
                    Directory directory3 = (Directory)directory2.newEntity((EntityType)ETDirectory.TYPE, string, null);
                    EntityLock entityLock2 = directory3.lockForWriting();
                    try {
                        directory3.setLastModified(tarEntryHeaderData.getLastModificationTime().getTime());
                    }
                    finally {
                        entityLock2.unlock();
                    }
                    directory2.setLastModified(l);
                    break block9;
                }
                if (overwriteResult == OverwriteResult.KEPT_OLD_DIRECTORY) {
                    directory2.getEntityOrNull(string).setLastModified(tarEntryHeaderData.getLastModificationTime().getTime());
                }
            }
            finally {
                entityLock.unlock();
            }
        }
        this.skipToNextBlockBoundary(dataSource, tarEntryHeaderData.getFileSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractFile(TarEntryHeaderData tarEntryHeaderData, DataSource dataSource, Directory directory, TarExtractSpecification tarExtractSpecification) {
        long l;
        block13: {
            String string = tarEntryHeaderData.getLocation().getName();
            Directory directory2 = this.getDirectory(directory, tarEntryHeaderData.getLocation().getParentLocation());
            EntityLock entityLock = directory2.lockForWriting();
            try {
                if (tarExtractSpecification.getOverwriteStrategy().overwrite(directory2, string, (EntityType)ETFile.TYPE) != OverwriteResult.CAN_CREATE_NEW_ENTITY) break block13;
                l = directory2.getLastModified();
                EFile eFile = (EFile)directory2.newEntity((EntityType)ETFile.TYPE, string, null);
                EntityLock entityLock2 = eFile.lockForWriting();
                try {
                    directory2.setLastModified(l);
                    entityLock.unlock();
                    entityLock = null;
                    try {
                        OutputStream outputStream = eFile.openForWrite();
                        try {
                            StreamUtil.copyStreams((InputStream)new DataSourceToInputStreamAdapter(dataSource), (OutputStream)outputStream, (int)eFile.getFileSystem().getBufferSize(), (long)tarEntryHeaderData.getFileSize());
                        }
                        finally {
                            outputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        throw new WrappedIOException(iOException);
                    }
                    eFile.setLastModified(tarEntryHeaderData.getLastModificationTime().getTime());
                }
                finally {
                    entityLock2.unlock();
                }
            }
            finally {
                if (entityLock != null) {
                    entityLock.unlock();
                }
            }
        }
        l = tarEntryHeaderData.getFileSize() % 512L;
        if (l > 0L) {
            dataSource.skipBytes(512L - l);
        }
    }

    protected void extractSymbolicLink(TarEntryHeaderData tarEntryHeaderData, DataSource dataSource, Directory directory, TarExtractSpecification tarExtractSpecification) {
        if (!this.m_ignoreSymbolicLinks) {
            throw new TarFileParseException("Cannot extract symbolic link " + tarEntryHeaderData.getLocation() + " -> " + tarEntryHeaderData.getLinkName() + ". Not supported. " + this.getClass().getName() + " can be configured to ignore symbolic links");
        }
        System.err.println("Ignoring symbolic link " + tarEntryHeaderData.getLocation() + " -> " + tarEntryHeaderData.getLinkName());
        this.skipToNextBlockBoundary(dataSource, tarEntryHeaderData.getFileSize());
    }

    public void extract(TarEntryHeaderData tarEntryHeaderData, DataSource dataSource, Directory directory, TarExtractSpecification tarExtractSpecification) throws WrappedIOException, TarFileParseException {
        char c = tarEntryHeaderData.getTypeFlag();
        if (tarEntryHeaderData.isDirectory()) {
            this.extractDirectory(tarEntryHeaderData, dataSource, directory, tarExtractSpecification);
        } else if (c == '0' || c == '\u0000') {
            this.extractFile(tarEntryHeaderData, dataSource, directory, tarExtractSpecification);
        } else if (c == '2') {
            this.extractSymbolicLink(tarEntryHeaderData, dataSource, directory, tarExtractSpecification);
        } else {
            throw new TarFileParseException("Don't know how to extract Tar entries with the type flag " + c);
        }
    }
}

