/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar;

import java.util.Date;
import org.at4j.archive.AbstractArchiveEntry;
import org.at4j.tar.TarDirectoryEntry;
import org.at4j.tar.TarEntryCollaborator;
import org.at4j.tar.TarEntryHeaderData;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.entityattrs.unix.UnixEntityMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TarEntry
extends AbstractArchiveEntry<TarEntry, TarDirectoryEntry> {
    private final UnixEntityMode m_entityMode;
    private final int m_ownerUid;
    private final int m_ownerGid;
    private final Date m_lastModificationTime;
    private final int m_checksum;

    TarEntry(TarEntryHeaderData tarEntryHeaderData, AbsoluteLocation absoluteLocation, TarEntryCollaborator tarEntryCollaborator) {
        super(absoluteLocation, tarEntryCollaborator);
        if (tarEntryHeaderData != null) {
            this.m_entityMode = tarEntryHeaderData.getMode();
            this.m_ownerUid = tarEntryHeaderData.getOwnerUid();
            this.m_ownerGid = tarEntryHeaderData.getOwnerGid();
            this.m_lastModificationTime = tarEntryHeaderData.getLastModificationTime();
            this.m_checksum = tarEntryHeaderData.getChecksum();
        } else {
            this.m_entityMode = this.getDefaultEntityMode();
            this.m_ownerUid = 0;
            this.m_ownerGid = 0;
            this.m_lastModificationTime = new Date();
            this.m_checksum = 0;
        }
    }

    protected abstract UnixEntityMode getDefaultEntityMode();

    public UnixEntityMode getEntityMode() {
        return this.m_entityMode;
    }

    public int getOwnerUid() {
        return this.m_ownerUid;
    }

    public int getOwnerGid() {
        return this.m_ownerGid;
    }

    public Date getLastModificationTime() {
        return (Date)this.m_lastModificationTime.clone();
    }

    public int getChecksum() {
        return this.m_checksum;
    }
}

