/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar;

import java.io.File;
import org.at4j.tar.PrintTarEntryExtractionStrategy;
import org.at4j.tar.TarExtractSpecification;
import org.at4j.tar.TarExtractorEntryHandler;
import org.at4j.tar.TarFileParseException;
import org.at4j.tar.TarFileParser;
import org.entityfs.DataSource;
import org.entityfs.Directory;
import org.entityfs.DirectoryView;
import org.entityfs.FileSystem;
import org.entityfs.ReadableFile;
import org.entityfs.exception.EntityNotFoundException;
import org.entityfs.exception.NotADirectoryException;
import org.entityfs.fs.FSRWFileSystemBuilder;
import org.entityfs.lock.EntityLock;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.util.FileReadableFile;
import org.entityfs.util.io.InputStreamToDataSourceAdapter;

public class TarExtractor {
    private final ReadableFile m_tarFile;

    public TarExtractor(ReadableFile readableFile) {
        readableFile.getClass();
        this.m_tarFile = readableFile;
    }

    public TarExtractor(File file) {
        file.getClass();
        this.m_tarFile = new FileReadableFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractInternal(Directory directory, TarExtractSpecification tarExtractSpecification) {
        EntityLock entityLock = this.m_tarFile.lockForReading();
        try {
            InputStreamToDataSourceAdapter inputStreamToDataSourceAdapter = new InputStreamToDataSourceAdapter(this.m_tarFile.openForRead());
            try {
                TarFileParser.INSTANCE.parse((DataSource)inputStreamToDataSourceAdapter, tarExtractSpecification.getFileNameCharset(), new TarExtractorEntryHandler(tarExtractSpecification, directory));
            }
            finally {
                inputStreamToDataSourceAdapter.close();
            }
        }
        finally {
            entityLock.unlock();
        }
    }

    public void extract(DirectoryView directoryView) throws TarFileParseException, WrappedIOException {
        this.extractInternal((Directory)directoryView.getViewedEntity(), new TarExtractSpecification());
    }

    public void extract(DirectoryView directoryView, TarExtractSpecification tarExtractSpecification) throws TarFileParseException, WrappedIOException {
        this.extractInternal(directoryView != null ? (Directory)directoryView.getViewedEntity() : null, tarExtractSpecification);
    }

    public void extract(File file) throws EntityNotFoundException, NotADirectoryException, TarFileParseException, WrappedIOException {
        this.extract(file, new TarExtractSpecification());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(File file, TarExtractSpecification tarExtractSpecification) throws EntityNotFoundException, NotADirectoryException, TarFileParseException, WrappedIOException {
        if (file == null) {
            this.extractInternal(null, tarExtractSpecification);
        } else {
            if (!file.exists()) {
                throw new EntityNotFoundException("The target directory " + file + " does not exist");
            }
            if (!file.isDirectory()) {
                throw new NotADirectoryException("The target " + file + " is not a directory");
            }
            FileSystem fileSystem = ((FSRWFileSystemBuilder)((FSRWFileSystemBuilder)((FSRWFileSystemBuilder)new FSRWFileSystemBuilder().disableAccessControls()).disableEntityValidityControls()).setRoot(file)).create();
            try {
                this.extractInternal(fileSystem.getRootDirectory(), tarExtractSpecification);
            }
            finally {
                fileSystem.close();
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("This class must be run with one and only one argument (the Tar file). Got " + stringArray.length);
            System.exit(1);
        }
        try {
            TarExtractSpecification tarExtractSpecification = new TarExtractSpecification();
            tarExtractSpecification.setEntryExtractionStrategy(new PrintTarEntryExtractionStrategy(System.out));
            new TarExtractor(new File(stringArray[0])).extract((File)null, tarExtractSpecification);
        }
        catch (WrappedIOException wrappedIOException) {
            System.err.println(wrappedIOException.getMessage());
            System.exit(1);
        }
    }
}

