/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.at4j.archive.Archive;
import org.at4j.tar.TarDirectoryEntry;
import org.at4j.tar.TarEntry;
import org.at4j.tar.TarEntryCollaborator;
import org.at4j.tar.TarFileContents;
import org.at4j.tar.TarFileContentsBuildingEntryHandlerDelegate;
import org.at4j.tar.TarFileEntry;
import org.at4j.tar.TarFileParser;
import org.at4j.tar.TarSymbolicLinkEntry;
import org.entityfs.DataSource;
import org.entityfs.RandomAccess;
import org.entityfs.RandomlyAccessibleFile;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.support.io.RandomAccessMode;
import org.entityfs.util.io.ReadWritableFileAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarFile
implements Archive<TarEntry, TarDirectoryEntry> {
    private final RandomlyAccessibleFile m_backingFile;
    private final Lock m_tarFileReadLock;
    private final Map<AbsoluteLocation, TarEntry> m_entries;
    private final TarDirectoryEntry m_rootEntry;
    private final TarEntryCollaborator m_entryCollaborator;
    private final AtomicBoolean m_closed;

    public TarFile(RandomlyAccessibleFile randomlyAccessibleFile) {
        this(randomlyAccessibleFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TarFile(RandomlyAccessibleFile randomlyAccessibleFile, Charset charset) {
        randomlyAccessibleFile.getClass();
        boolean bl = false;
        this.m_backingFile = randomlyAccessibleFile;
        this.m_tarFileReadLock = randomlyAccessibleFile.lockForReading();
        try {
            this.m_entryCollaborator = new TarEntryCollaborator(randomlyAccessibleFile, this);
            RandomAccess randomAccess = randomlyAccessibleFile.openForRandomAccess(RandomAccessMode.READ_ONLY);
            try {
                TarFileContentsBuildingEntryHandlerDelegate tarFileContentsBuildingEntryHandlerDelegate = new TarFileContentsBuildingEntryHandlerDelegate(this.m_entryCollaborator);
                TarFileParser.INSTANCE.parse((DataSource)randomAccess, charset != null ? charset : Charset.defaultCharset(), tarFileContentsBuildingEntryHandlerDelegate);
                TarFileContents tarFileContents = tarFileContentsBuildingEntryHandlerDelegate.getContents();
                this.m_entries = Collections.unmodifiableMap(tarFileContents.getEntryMap());
                this.m_rootEntry = tarFileContents.getRootEntry();
                bl = true;
            }
            finally {
                randomAccess.close();
            }
        }
        finally {
            if (!bl) {
                this.m_tarFileReadLock.unlock();
            }
        }
        this.m_closed = new AtomicBoolean(false);
    }

    protected void assertNotClosed() throws IllegalStateException {
        if (this.m_closed.get()) {
            throw new IllegalStateException("This Zip file is closed");
        }
    }

    @Override
    public TarDirectoryEntry getRootEntry() {
        this.assertNotClosed();
        return this.m_rootEntry;
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object object) throws IllegalStateException {
        this.assertNotClosed();
        return this.m_entries.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) throws IllegalStateException {
        this.assertNotClosed();
        return this.m_entries.containsValue(object);
    }

    @Override
    public Set<Map.Entry<AbsoluteLocation, TarEntry>> entrySet() throws IllegalStateException {
        this.assertNotClosed();
        return this.m_entries.entrySet();
    }

    @Override
    public TarEntry get(Object object) throws IllegalStateException {
        this.assertNotClosed();
        return this.m_entries.get(object);
    }

    @Override
    public boolean isEmpty() throws IllegalStateException {
        this.assertNotClosed();
        return false;
    }

    @Override
    public Set<AbsoluteLocation> keySet() throws IllegalStateException {
        this.assertNotClosed();
        return this.m_entries.keySet();
    }

    @Override
    public TarEntry put(AbsoluteLocation absoluteLocation, TarEntry tarEntry) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends AbsoluteLocation, ? extends TarEntry> map) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TarEntry remove(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() throws IllegalStateException {
        this.assertNotClosed();
        return this.m_entries.size();
    }

    @Override
    public Collection<TarEntry> values() throws IllegalStateException {
        this.assertNotClosed();
        return this.m_entries.values();
    }

    public RandomlyAccessibleFile getBackingFile() {
        return this.m_backingFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.m_closed.getAndSet(true)) {
            try {
                this.m_entryCollaborator.close();
            }
            finally {
                this.m_tarFileReadLock.unlock();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private static void printDirectory(TarDirectoryEntry tarDirectoryEntry) {
        if (tarDirectoryEntry.isEmpty()) {
            System.out.println(tarDirectoryEntry.getLocation().getLocation().substring(1) + "/");
        } else {
            for (TarEntry tarEntry : tarDirectoryEntry.getChildEntries().values()) {
                if (tarEntry instanceof TarFileEntry) {
                    System.out.println(tarEntry.getLocation().getLocation().substring(1));
                    continue;
                }
                if (tarEntry instanceof TarDirectoryEntry) {
                    TarFile.printDirectory((TarDirectoryEntry)tarEntry);
                    continue;
                }
                if (tarEntry instanceof TarSymbolicLinkEntry) {
                    System.out.println(tarEntry.getLocation().getLocation().substring(1) + " -> " + ((TarSymbolicLinkEntry)tarEntry).getLinkTarget());
                    continue;
                }
                System.err.println("Unknown entry type: " + tarEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("This class must be run with one and only one argument (the Tar file). Got " + stringArray.length);
            System.exit(1);
        }
        try {
            TarFile tarFile = new TarFile((RandomlyAccessibleFile)new ReadWritableFileAdapter(new File(stringArray[0])));
            try {
                TarFile.printDirectory(tarFile.getRootEntry());
            }
            finally {
                tarFile.close();
            }
        }
        catch (WrappedIOException wrappedIOException) {
            System.err.println(wrappedIOException.getMessage());
            System.exit(1);
        }
    }
}

