/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.at4j.tar.PaxDirectoryEntry;
import org.at4j.tar.PaxFileEntry;
import org.at4j.tar.PaxSymbolicLinkEntry;
import org.at4j.tar.TarDirectoryEntry;
import org.at4j.tar.TarEntry;
import org.at4j.tar.TarEntryCollaborator;
import org.at4j.tar.TarEntryHandlerDelegate;
import org.at4j.tar.TarEntryHeaderData;
import org.at4j.tar.TarFileContents;
import org.at4j.tar.TarFileEntry;
import org.at4j.tar.TarFileParseException;
import org.at4j.tar.TarSymbolicLinkEntry;
import org.at4j.tar.UstarDirectoryEntry;
import org.at4j.tar.UstarFileEntry;
import org.at4j.tar.UstarSymbolicLinkEntry;
import org.entityfs.DataSource;
import org.entityfs.RandomAccess;
import org.entityfs.el.AbsoluteLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TarFileContentsBuildingEntryHandlerDelegate
implements TarEntryHandlerDelegate {
    private static final String USTAR_MAGIC = "ustar";
    private final TarEntryCollaborator m_collaborator;
    private final TarEntryNode m_rootNode = new TarEntryNode();
    private int m_numberOfEntries;

    TarFileContentsBuildingEntryHandlerDelegate(TarEntryCollaborator tarEntryCollaborator) {
        this.m_collaborator = tarEntryCollaborator;
    }

    private void putInTree(TarEntryNode tarEntryNode, TarEntryHeaderData tarEntryHeaderData, LinkedList<String> linkedList, long l) {
        String string = linkedList.remove(0);
        TarEntryNode tarEntryNode2 = (TarEntryNode)tarEntryNode.m_childNodes.get(string);
        if (tarEntryNode2 == null) {
            tarEntryNode2 = new TarEntryNode();
            tarEntryNode.m_childNodes.put(string, tarEntryNode2);
        }
        if (linkedList.isEmpty()) {
            tarEntryNode2.m_headerData = tarEntryHeaderData;
            tarEntryNode2.m_startPosOfFileData = l;
        } else {
            this.putInTree(tarEntryNode2, tarEntryHeaderData, linkedList, l);
        }
    }

    @Override
    public long handle(TarEntryHeaderData tarEntryHeaderData, DataSource dataSource) {
        ++this.m_numberOfEntries;
        if (!(dataSource instanceof RandomAccess)) {
            throw new RuntimeException("Bug: expected a RandomAccess source");
        }
        this.putInTree(this.m_rootNode, tarEntryHeaderData, tarEntryHeaderData.getLocation().getPathSegmentStack(), ((RandomAccess)dataSource).getFilePointer());
        return tarEntryHeaderData.getFileSize();
    }

    private TarDirectoryEntry createDirectoryEntry(TarEntryHeaderData tarEntryHeaderData, AbsoluteLocation absoluteLocation, Map<String, TarEntry> map, TarEntryCollaborator tarEntryCollaborator) {
        if (tarEntryHeaderData != null && USTAR_MAGIC.equals(tarEntryHeaderData.getMagic())) {
            if (tarEntryHeaderData.getVariables() != null) {
                return new PaxDirectoryEntry(tarEntryHeaderData, absoluteLocation, tarEntryCollaborator, map);
            }
            return new UstarDirectoryEntry(tarEntryHeaderData, absoluteLocation, tarEntryCollaborator, map);
        }
        return new TarDirectoryEntry(tarEntryHeaderData, absoluteLocation, tarEntryCollaborator, map);
    }

    private TarFileEntry createFileEntry(TarEntryHeaderData tarEntryHeaderData, long l, TarEntryCollaborator tarEntryCollaborator) {
        if (USTAR_MAGIC.equals(tarEntryHeaderData.getMagic())) {
            if (tarEntryHeaderData.getVariables() != null) {
                return new PaxFileEntry(tarEntryHeaderData, l, tarEntryCollaborator);
            }
            return new UstarFileEntry(tarEntryHeaderData, l, tarEntryCollaborator);
        }
        return new TarFileEntry(tarEntryHeaderData, l, tarEntryCollaborator);
    }

    private TarSymbolicLinkEntry createSymbolicLinkEntry(TarEntryHeaderData tarEntryHeaderData, TarEntryCollaborator tarEntryCollaborator) {
        if (USTAR_MAGIC.equals(tarEntryHeaderData.getMagic())) {
            if (tarEntryHeaderData.getVariables() != null) {
                return new PaxSymbolicLinkEntry(tarEntryHeaderData, tarEntryCollaborator);
            }
            return new UstarSymbolicLinkEntry(tarEntryHeaderData, tarEntryCollaborator);
        }
        return new TarSymbolicLinkEntry(tarEntryHeaderData, tarEntryCollaborator);
    }

    private TarEntry createEntries(TarEntryNode tarEntryNode, AbsoluteLocation absoluteLocation, Map<AbsoluteLocation, TarEntry> map, TarEntryCollaborator tarEntryCollaborator) {
        TarEntryHeaderData tarEntryHeaderData = tarEntryNode.m_headerData;
        if (tarEntryNode.m_childNodes.size() > 0) {
            if (tarEntryHeaderData != null && !tarEntryHeaderData.isDirectory()) {
                throw new TarFileParseException("The entry " + tarEntryHeaderData.getLocation() + " has child entries but is not a directory");
            }
            HashMap<String, TarEntry> hashMap = new HashMap<String, TarEntry>(tarEntryNode.m_childNodes.size());
            for (Map.Entry entry : tarEntryNode.m_childNodes.entrySet()) {
                AbsoluteLocation absoluteLocation2 = absoluteLocation.getChildLocation((String)entry.getKey());
                TarEntry tarEntry = this.createEntries((TarEntryNode)entry.getValue(), absoluteLocation2, map, tarEntryCollaborator);
                map.put(absoluteLocation2, tarEntry);
                hashMap.put((String)entry.getKey(), tarEntry);
            }
            return this.createDirectoryEntry(tarEntryHeaderData, absoluteLocation, hashMap, tarEntryCollaborator);
        }
        if (tarEntryHeaderData == null || tarEntryHeaderData.isDirectory()) {
            assert (tarEntryHeaderData == null || tarEntryHeaderData.getTypeFlag() == '5' || !USTAR_MAGIC.equals(tarEntryHeaderData.getMagic()));
            return this.createDirectoryEntry(tarEntryHeaderData, absoluteLocation, Collections.EMPTY_MAP, tarEntryCollaborator);
        }
        if (tarEntryHeaderData.getTypeFlag() == '0' || tarEntryHeaderData.getTypeFlag() == '\u0000') {
            return this.createFileEntry(tarEntryHeaderData, tarEntryNode.m_startPosOfFileData, tarEntryCollaborator);
        }
        if (tarEntryHeaderData.getTypeFlag() == '2') {
            return this.createSymbolicLinkEntry(tarEntryHeaderData, tarEntryCollaborator);
        }
        System.err.println("Don't understand the entry type flag " + tarEntryHeaderData.getTypeFlag() + ". This entry will be treated as a regular file.");
        return this.createFileEntry(tarEntryHeaderData, tarEntryNode.m_startPosOfFileData, tarEntryCollaborator);
    }

    TarFileContents getContents() {
        HashMap<AbsoluteLocation, TarEntry> hashMap = new HashMap<AbsoluteLocation, TarEntry>(this.m_numberOfEntries);
        TarDirectoryEntry tarDirectoryEntry = (TarDirectoryEntry)this.createEntries(this.m_rootNode, AbsoluteLocation.ROOT_DIR, hashMap, this.m_collaborator);
        hashMap.put(AbsoluteLocation.ROOT_DIR, tarDirectoryEntry);
        return new TarFileContents(tarDirectoryEntry, hashMap);
    }

    private static class TarEntryNode {
        private TarEntryHeaderData m_headerData;
        private Map<String, TarEntryNode> m_childNodes = new HashMap<String, TarEntryNode>();
        private long m_startPosOfFileData;

        private TarEntryNode() {
        }
    }
}

