/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ScatteringByteChannel;
import org.at4j.archive.ArchiveFileEntry;
import org.at4j.tar.TarDirectoryEntry;
import org.at4j.tar.TarEntry;
import org.at4j.tar.TarEntryCollaborator;
import org.at4j.tar.TarEntryHeaderData;
import org.entityfs.RandomAccess;
import org.entityfs.entityattrs.unix.UnixEntityMode;
import org.entityfs.exception.LockTimeoutException;
import org.entityfs.exception.ReadOnlyException;
import org.entityfs.lock.DummyLock;
import org.entityfs.lock.EntityLock;
import org.entityfs.support.io.RandomAccessMode;
import org.entityfs.support.io.ScatteringByteChannelAdapter;
import org.entityfs.util.base.EmptyRandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarFileEntry
extends TarEntry
implements ArchiveFileEntry<TarEntry, TarDirectoryEntry> {
    private static final UnixEntityMode DEFAULT_ENTITY_MODE = UnixEntityMode.forCode((int)420);
    private final long m_startPosOfFileData;
    private final long m_size;

    TarFileEntry(TarEntryHeaderData tarEntryHeaderData, long l, TarEntryCollaborator tarEntryCollaborator) {
        super(tarEntryHeaderData, tarEntryHeaderData.getLocation(), tarEntryCollaborator);
        this.m_startPosOfFileData = l;
        this.m_size = tarEntryHeaderData.getFileSize();
    }

    @Override
    protected UnixEntityMode getDefaultEntityMode() {
        return DEFAULT_ENTITY_MODE;
    }

    public EntityLock lockForWriting() throws LockTimeoutException {
        return DummyLock.INSTANCE;
    }

    public EntityLock getWriteLock() {
        return DummyLock.INSTANCE;
    }

    public boolean isWriteLockedByCurrentThread() {
        return true;
    }

    public ScatteringByteChannel openChannelForRead() {
        return new ScatteringByteChannelAdapter(Channels.newChannel(this.openForRead()));
    }

    public InputStream openForRead() {
        if (this.m_size == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return this.getCollaborator().openStream(this.m_startPosOfFileData, this.m_startPosOfFileData + this.m_size - 1L);
    }

    public RandomAccess openForRandomAccess(RandomAccessMode randomAccessMode) throws ReadOnlyException {
        if (randomAccessMode != RandomAccessMode.READ_ONLY) {
            throw new ReadOnlyException("A Tar entry is read only");
        }
        if (this.m_size == 0L) {
            return new EmptyRandomAccess();
        }
        return this.getCollaborator().openRandomAccess(this.m_startPosOfFileData, this.m_startPosOfFileData + this.m_size - 1L);
    }

    public long getStartPosOfFileData() {
        return this.m_startPosOfFileData;
    }

    public long getDataSize() {
        return this.m_size;
    }

    public long getSize() {
        return this.m_size;
    }
}

