/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.at4j.support.nio.charset.Charsets;
import org.at4j.tar.GnuExtendedInformationHeader;
import org.at4j.tar.PaxHeader;
import org.at4j.tar.TarEntryHandlerDelegate;
import org.at4j.tar.TarEntryHeader;
import org.at4j.tar.TarEntryHeaderData;
import org.at4j.tar.TarFileParseException;
import org.entityfs.DataSource;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.entityattrs.unix.UnixEntityMode;
import org.entityfs.support.exception.WrappedIOException;

public final class TarFileParser {
    public static final TarFileParser INSTANCE = new TarFileParser();
    private static final byte[] EMPTY_BLOCK = new byte[512];

    private TarFileParser() {
    }

    private UnixEntityMode parseEntityMode(String string) {
        return UnixEntityMode.forCode((int)Integer.parseInt(string, 8));
    }

    private byte[] readEofOk(DataSource dataSource, int n) {
        byte[] byArray = new byte[n];
        int n2 = dataSource.read(byArray);
        if (n2 == -1) {
            return null;
        }
        if (n2 != n) {
            throw new TarFileParseException("Wanted to read " + n + " bytes. Got " + n2);
        }
        return byArray;
    }

    private byte[] read(DataSource dataSource, int n) {
        byte[] byArray = this.readEofOk(dataSource, n);
        if (byArray == null) {
            throw new TarFileParseException("Wanted to read " + n + " bytes. Got EOF");
        }
        return byArray;
    }

    private void skipForward(DataSource dataSource, long l, int n) {
        long l2 = (l == 0L ? 0L : ((l - 1L) / 512L + 1L) * 512L) + (long)n;
        long l3 = dataSource.skipBytes(l2);
        if (l3 != l2) {
            throw new TarFileParseException("Wanted to skip " + l2 + " bytes. Only skipped " + l3);
        }
    }

    private GnuExtendedInformationHeader parseGnuLongFileNameHeader(DataSource dataSource, Charset charset, int n, GnuExtendedInformationHeader gnuExtendedInformationHeader) {
        byte[] byArray = this.read(dataSource, n);
        String string = charset.decode(ByteBuffer.wrap(byArray)).toString().trim();
        if (string.endsWith("/")) {
            while ((string = string.substring(0, string.length() - 1)).endsWith("/")) {
            }
            gnuExtendedInformationHeader.setDirectory(Boolean.TRUE);
        } else {
            gnuExtendedInformationHeader.setDirectory(Boolean.FALSE);
        }
        gnuExtendedInformationHeader.setFileName(new AbsoluteLocation("/" + string));
        this.skipForward(dataSource, 0L, 512 - n % 512);
        return gnuExtendedInformationHeader;
    }

    private GnuExtendedInformationHeader parseGnuLongLinkTargetHeader(DataSource dataSource, Charset charset, int n, GnuExtendedInformationHeader gnuExtendedInformationHeader) {
        byte[] byArray = this.read(dataSource, n);
        String string = charset.decode(ByteBuffer.wrap(byArray)).toString().trim();
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        gnuExtendedInformationHeader.setLinkName(string);
        this.skipForward(dataSource, 0L, 512 - n % 512);
        return gnuExtendedInformationHeader;
    }

    private PaxHeader parsePaxHeader(DataSource dataSource, int n) {
        int n2;
        int n3;
        byte[] byArray = this.read(dataSource, n);
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        for (int i = 0; i < n; i += n3 - n2) {
            n3 = 0;
            n2 = 0;
            char c = (char)byArray[i];
            while (c != ' ' && c != '\u0000') {
                n3 = 10 * n3 + (c - 48);
                ++n2;
                c = (char)byArray[++i];
            }
            String string = Charsets.UTF8.decode(ByteBuffer.wrap(byArray, ++i, n3 - ++n2)).toString().trim();
            int n4 = string.indexOf(61);
            hashMap.put(string.substring(0, n4), string.substring(n4 + 1));
        }
        this.skipForward(dataSource, 0L, 512 - n % 512);
        return new PaxHeader(hashMap);
    }

    private TarEntryHeader readEntryHeader(DataSource dataSource, Charset charset, TarEntryHeader tarEntryHeader) throws TarFileParseException {
        String string;
        String string2;
        Object object;
        byte[] byArray = this.readEofOk(dataSource, 512);
        if (byArray == null) {
            return null;
        }
        if (Arrays.equals(byArray, EMPTY_BLOCK)) {
            return null;
        }
        TarEntryHeaderData tarEntryHeaderData = new TarEntryHeaderData();
        long l = Long.parseLong(charset.decode(ByteBuffer.wrap(byArray, 124, 12)).toString().trim(), 8);
        tarEntryHeaderData.setFileSize(l);
        tarEntryHeaderData.setTypeFlag(charset.decode(ByteBuffer.wrap(byArray, 156, 1)).toString().charAt(0));
        if ('L' == tarEntryHeaderData.getTypeFlag()) {
            assert (tarEntryHeader == null || tarEntryHeader instanceof GnuExtendedInformationHeader);
            return this.parseGnuLongFileNameHeader(dataSource, charset, (int)l, tarEntryHeader != null ? (GnuExtendedInformationHeader)tarEntryHeader : new GnuExtendedInformationHeader());
        }
        if ('K' == tarEntryHeaderData.getTypeFlag()) {
            assert (tarEntryHeader == null || tarEntryHeader instanceof GnuExtendedInformationHeader);
            return this.parseGnuLongLinkTargetHeader(dataSource, charset, (int)l, tarEntryHeader != null ? (GnuExtendedInformationHeader)tarEntryHeader : new GnuExtendedInformationHeader());
        }
        if ('x' == tarEntryHeaderData.getTypeFlag() || 'X' == tarEntryHeaderData.getTypeFlag()) {
            assert (tarEntryHeader == null);
            return this.parsePaxHeader(dataSource, (int)l);
        }
        String string3 = charset.decode(ByteBuffer.wrap(byArray, 0, 100)).toString().trim();
        if (string3.endsWith("/")) {
            tarEntryHeaderData.setDirectory(true);
            string3 = string3.substring(0, string3.length() - 1);
        } else {
            tarEntryHeaderData.setDirectory('5' == tarEntryHeaderData.getTypeFlag());
        }
        tarEntryHeaderData.setMode(this.parseEntityMode(charset.decode(ByteBuffer.wrap(byArray, 100, 8)).toString().trim()));
        tarEntryHeaderData.setOwnerUid(Integer.parseInt(charset.decode(ByteBuffer.wrap(byArray, 108, 8)).toString().trim(), 8));
        tarEntryHeaderData.setOwnerGid(Integer.parseInt(charset.decode(ByteBuffer.wrap(byArray, 116, 8)).toString().trim(), 8));
        tarEntryHeaderData.setLastModificationTime(new Date(Long.parseLong(charset.decode(ByteBuffer.wrap(byArray, 136, 12)).toString().trim(), 8) * 1000L));
        tarEntryHeaderData.setChecksum(Integer.parseInt(charset.decode(ByteBuffer.wrap(byArray, 148, 8)).toString().trim(), 8));
        tarEntryHeaderData.setLinkName(charset.decode(ByteBuffer.wrap(byArray, 157, 100)).toString().trim());
        tarEntryHeaderData.setMagic(charset.decode(ByteBuffer.wrap(byArray, 257, 6)).toString().trim().intern());
        if ("ustar".equals(tarEntryHeaderData.getMagic())) {
            tarEntryHeaderData.setUstarVersion(charset.decode(ByteBuffer.wrap(byArray, 263, 2)).toString().trim().intern());
            tarEntryHeaderData.setOwnerName(charset.decode(ByteBuffer.wrap(byArray, 265, 32)).toString().trim().intern());
            tarEntryHeaderData.setGroupName(charset.decode(ByteBuffer.wrap(byArray, 297, 32)).toString().trim().intern());
            object = charset.decode(ByteBuffer.wrap(byArray, 329, 8)).toString().trim();
            tarEntryHeaderData.setDevMajor(((String)object).length() > 0 ? Integer.parseInt((String)object, 8) : 0);
            string2 = charset.decode(ByteBuffer.wrap(byArray, 337, 8)).toString().trim();
            tarEntryHeaderData.setDevMinor(string2.length() > 0 ? Integer.parseInt(string2, 8) : 0);
            string = charset.decode(ByteBuffer.wrap(byArray, 345, 155)).toString().trim();
            if (string.length() > 0) {
                string3 = string + "/" + string3;
            }
            tarEntryHeaderData.setLocation(new AbsoluteLocation("/" + string3));
        } else {
            tarEntryHeaderData.setLocation(new AbsoluteLocation("/" + string3));
        }
        if (tarEntryHeader != null) {
            if (tarEntryHeader instanceof GnuExtendedInformationHeader) {
                object = (GnuExtendedInformationHeader)tarEntryHeader;
                if (((GnuExtendedInformationHeader)object).getFileName() != null) {
                    tarEntryHeaderData.setLocation(((GnuExtendedInformationHeader)object).getFileName());
                    tarEntryHeaderData.setDirectory(((GnuExtendedInformationHeader)object).isDirectory());
                }
                if (((GnuExtendedInformationHeader)object).getLinkName() != null) {
                    tarEntryHeaderData.setLinkName(((GnuExtendedInformationHeader)object).getLinkName());
                }
            } else if (tarEntryHeader instanceof PaxHeader) {
                object = ((PaxHeader)tarEntryHeader).getVariables();
                tarEntryHeaderData.setVariables((Map<String, String>)object);
                string2 = (String)object.get("path");
                if (string2 != null) {
                    if (string2.endsWith("/")) {
                        tarEntryHeaderData.setLocation(new AbsoluteLocation("/" + string2.substring(0, string2.length() - 1)));
                        tarEntryHeaderData.setDirectory(true);
                    } else {
                        tarEntryHeaderData.setLocation(new AbsoluteLocation("/" + string2));
                    }
                }
                if ((string = (String)object.get("linkpath")) != null) {
                    tarEntryHeaderData.setLinkName(string);
                }
            }
        }
        return tarEntryHeaderData;
    }

    public void parse(DataSource dataSource, Charset charset, TarEntryHandlerDelegate tarEntryHandlerDelegate) throws TarFileParseException, WrappedIOException {
        try {
            TarEntryHeader tarEntryHeader = null;
            TarEntryHeader tarEntryHeader2 = this.readEntryHeader(dataSource, charset, null);
            while (tarEntryHeader2 != null) {
                if (tarEntryHeader2 instanceof TarEntryHeaderData) {
                    TarEntryHeaderData tarEntryHeaderData = (TarEntryHeaderData)tarEntryHeader2;
                    long l = tarEntryHandlerDelegate.handle(tarEntryHeaderData, dataSource);
                    if (l > 0L) {
                        this.skipForward(dataSource, l, 0);
                    }
                    tarEntryHeader = null;
                } else {
                    tarEntryHeader = tarEntryHeader2;
                }
                tarEntryHeader2 = this.readEntryHeader(dataSource, charset, tarEntryHeader);
            }
        }
        catch (WrappedIOException wrappedIOException) {
            throw wrappedIOException;
        }
        catch (RuntimeException runtimeException) {
            throw new TarFileParseException(runtimeException);
        }
    }

    static {
        Arrays.fill(EMPTY_BLOCK, (byte)0);
    }
}

