/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar.builder;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import org.at4j.support.nio.charset.Charsets;
import org.at4j.tar.builder.DirectoryAdapter;
import org.at4j.tar.builder.TarEntrySettings;
import org.at4j.tar.builder.UstarEntryStrategy;
import org.entityfs.DataSink;
import org.entityfs.RandomAccess;
import org.entityfs.ReadableFile;
import org.entityfs.el.AbsoluteLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GnuTarEntryStrategy
extends UstarEntryStrategy {
    private static final byte[] GNU_LONG_FILE_NAME_HEADER_TEMPLATE = new byte[512];

    public GnuTarEntryStrategy() {
    }

    public GnuTarEntryStrategy(Charset charset) {
        super(charset);
    }

    private void writeGnuLongFileNameHeader(DataSink dataSink, byte[] byArray) {
        byte[] byArray2 = new byte[512];
        System.arraycopy(GNU_LONG_FILE_NAME_HEADER_TEMPLATE, 0, byArray2, 0, 512);
        System.arraycopy(this.zeroPadLeft(Integer.toOctalString(byArray.length), 11), 0, byArray2, 124, 11);
        this.addChecksumToHeader(byArray2);
        dataSink.write(byArray2);
        dataSink.write(byArray);
        this.goToNextBlockBoundary(dataSink, byArray2.length + byArray.length);
    }

    private AbsoluteLocation addLongFileNameHeaderIfNecessary(DataSink dataSink, AbsoluteLocation absoluteLocation) {
        String string = this.getFileName(absoluteLocation, false);
        byte[] byArray = Charsets.getBytes(string, this.getTextEncodingCharset());
        if (byArray.length > 99) {
            this.writeGnuLongFileNameHeader(dataSink, byArray);
            String string2 = this.getTextEncodingCharset().decode(ByteBuffer.wrap(byArray, 0, 99)).toString();
            while (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            absoluteLocation = new AbsoluteLocation("/" + string2);
        }
        return absoluteLocation;
    }

    @Override
    public void writeFile(DataSink dataSink, ReadableFile readableFile, AbsoluteLocation absoluteLocation, TarEntrySettings tarEntrySettings, Date date) {
        absoluteLocation = this.addLongFileNameHeaderIfNecessary(dataSink, absoluteLocation);
        super.writeFile(dataSink, readableFile, absoluteLocation, tarEntrySettings, date);
    }

    @Override
    public void writeFileFromStream(RandomAccess randomAccess, InputStream inputStream, AbsoluteLocation absoluteLocation, TarEntrySettings tarEntrySettings, Date date) {
        absoluteLocation = this.addLongFileNameHeaderIfNecessary((DataSink)randomAccess, absoluteLocation);
        super.writeFileFromStream(randomAccess, inputStream, absoluteLocation, tarEntrySettings, date);
    }

    @Override
    public void writeDirectory(DataSink dataSink, DirectoryAdapter<?> directoryAdapter, AbsoluteLocation absoluteLocation, TarEntrySettings tarEntrySettings, Date date) {
        absoluteLocation = this.addLongFileNameHeaderIfNecessary(dataSink, absoluteLocation);
        super.writeDirectory(dataSink, directoryAdapter, absoluteLocation, tarEntrySettings, date);
    }

    static {
        byte[] byArray = "././@LongLink".getBytes();
        System.arraycopy(byArray, 0, GNU_LONG_FILE_NAME_HEADER_TEMPLATE, 0, byArray.length);
        byte[] byArray2 = new byte[11];
        Arrays.fill(byArray2, (byte)48);
        System.arraycopy(byArray2, 0, GNU_LONG_FILE_NAME_HEADER_TEMPLATE, 100, 7);
        System.arraycopy(byArray2, 0, GNU_LONG_FILE_NAME_HEADER_TEMPLATE, 108, 7);
        System.arraycopy(byArray2, 0, GNU_LONG_FILE_NAME_HEADER_TEMPLATE, 116, 7);
        System.arraycopy(byArray2, 0, GNU_LONG_FILE_NAME_HEADER_TEMPLATE, 136, 11);
        GnuTarEntryStrategy.GNU_LONG_FILE_NAME_HEADER_TEMPLATE[156] = 76;
        System.arraycopy("ustar  ".getBytes(), 0, GNU_LONG_FILE_NAME_HEADER_TEMPLATE, 257, 7);
        byte[] byArray3 = "root".getBytes();
        System.arraycopy(byArray3, 0, GNU_LONG_FILE_NAME_HEADER_TEMPLATE, 265, 4);
        System.arraycopy(byArray3, 0, GNU_LONG_FILE_NAME_HEADER_TEMPLATE, 297, 4);
    }
}

