/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar.builder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.at4j.support.nio.charset.Charsets;
import org.at4j.tar.builder.DirectoryAdapter;
import org.at4j.tar.builder.PaxVariableProvider;
import org.at4j.tar.builder.TarEntrySettings;
import org.at4j.tar.builder.UstarEntryStrategy;
import org.entityfs.DataSink;
import org.entityfs.ETFile;
import org.entityfs.EntityType;
import org.entityfs.RandomAccess;
import org.entityfs.ReadableFile;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.entityattrs.unix.UnixEntityMode;
import org.entityfs.support.exception.WrappedIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaxTarEntryStrategy
extends UstarEntryStrategy {
    private static final int DEFAULT_PID = 1000;
    private final List<PaxVariableProvider> m_variableProviders = new ArrayList<PaxVariableProvider>(2);
    private int m_processId = 1000;

    public PaxTarEntryStrategy() {
    }

    public PaxTarEntryStrategy(Charset charset) {
        super(charset);
    }

    public PaxTarEntryStrategy setProcessId(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid process id " + n + ". The process id must be >= 1");
        }
        this.m_processId = n;
        return this;
    }

    public int getProcessId() {
        return this.m_processId;
    }

    public PaxTarEntryStrategy addPaxVariableProvider(PaxVariableProvider paxVariableProvider) {
        paxVariableProvider.getClass();
        this.m_variableProviders.add(paxVariableProvider);
        return this;
    }

    private AbsoluteLocation truncateLocation(AbsoluteLocation absoluteLocation) {
        byte[] byArray = Charsets.getBytes(absoluteLocation.getLocation(), this.getTextEncodingCharset());
        if (byArray.length > 100) {
            String string = this.getTextEncodingCharset().decode(ByteBuffer.wrap(byArray, 0, 100)).toString();
            while (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            absoluteLocation = new AbsoluteLocation(string);
        }
        return absoluteLocation;
    }

    private byte[] createVariablesData(Object object, AbsoluteLocation absoluteLocation, TarEntrySettings tarEntrySettings, Date date) {
        HashMap<String, String> hashMap = new HashMap<String, String>(8);
        long l = date.getTime();
        hashMap.put("mtime", "" + l / 1000L + "." + l % 1000L + "000000");
        String string = absoluteLocation.getLocation().substring(1);
        byte[] byArray = Charsets.getBytes(string, Charsets.UTF8);
        if (byArray.length > 99) {
            hashMap.put("path", string);
        } else if (byArray.length != string.length()) {
            hashMap.put("path", string);
        }
        for (PaxVariableProvider object2 : this.m_variableProviders) {
            object2.addVariables(hashMap, object, absoluteLocation, tarEntrySettings, date);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (Map.Entry entry : hashMap.entrySet()) {
                byte[] byArray2 = Charsets.getBytes(" " + (String)entry.getKey() + "=" + (String)entry.getValue() + "\n", Charsets.UTF8);
                int n = byArray2.length;
                int n2 = ("" + n).length();
                int n3 = n + n2;
                int n4 = ("" + n3).length();
                if (n4 > n2) {
                    ++n3;
                }
                byteArrayOutputStream.write(("" + n3).getBytes());
                byteArrayOutputStream.write(byArray2);
            }
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
    }

    private void writePaxHeader(DataSink dataSink, Object object, AbsoluteLocation absoluteLocation, TarEntrySettings tarEntrySettings, Date date) {
        AbsoluteLocation absoluteLocation2 = absoluteLocation.getParentLocation();
        String string = this.truncateLocation(absoluteLocation2.getChildLocation("PaxHeader." + this.m_processId).getChildLocation(absoluteLocation.getName())).getLocation().substring(1);
        byte[] byArray = this.createVariablesData(object, absoluteLocation, tarEntrySettings, date);
        TarEntrySettings tarEntrySettings2 = new TarEntrySettings();
        tarEntrySettings2.setEntityMode(UnixEntityMode.forCode((int)420));
        tarEntrySettings2.setOwnerUid(tarEntrySettings.getOwnerUid());
        tarEntrySettings2.setOwnerGid(tarEntrySettings.getOwnerGid());
        tarEntrySettings2.setOwnerUserName(tarEntrySettings.getOwnerUserName());
        tarEntrySettings2.setOwnerGroupName(tarEntrySettings.getOwnerGroupName());
        byte[] byArray2 = this.getHeader(null, string, tarEntrySettings2, byArray.length, (EntityType)ETFile.TYPE, date);
        byArray2[156] = 120;
        this.addChecksumToHeader(byArray2);
        dataSink.write(byArray2);
        dataSink.write(byArray);
        this.goToNextBlockBoundary(dataSink, byArray2.length + byArray.length);
    }

    @Override
    public void writeFile(DataSink dataSink, ReadableFile readableFile, AbsoluteLocation absoluteLocation, TarEntrySettings tarEntrySettings, Date date) {
        this.writePaxHeader(dataSink, readableFile, absoluteLocation, tarEntrySettings, date);
        absoluteLocation = this.truncateLocation(absoluteLocation);
        super.writeFile(dataSink, readableFile, absoluteLocation, tarEntrySettings, date);
    }

    @Override
    public void writeFileFromStream(RandomAccess randomAccess, InputStream inputStream, AbsoluteLocation absoluteLocation, TarEntrySettings tarEntrySettings, Date date) {
        this.writePaxHeader((DataSink)randomAccess, inputStream, absoluteLocation, tarEntrySettings, date);
        absoluteLocation = this.truncateLocation(absoluteLocation);
        super.writeFileFromStream(randomAccess, inputStream, absoluteLocation, tarEntrySettings, date);
    }

    @Override
    public void writeDirectory(DataSink dataSink, DirectoryAdapter<?> directoryAdapter, AbsoluteLocation absoluteLocation, TarEntrySettings tarEntrySettings, Date date) {
        this.writePaxHeader(dataSink, directoryAdapter, absoluteLocation, tarEntrySettings, date);
        absoluteLocation = this.truncateLocation(absoluteLocation);
        super.writeDirectory(dataSink, directoryAdapter, absoluteLocation, tarEntrySettings, date);
    }
}

