/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar.builder;

import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import org.at4j.archive.builder.AbstractStreamAddCapableArchiveBuilder;
import org.at4j.archive.builder.ArchiveEntryAddException;
import org.at4j.tar.builder.DirectoryAdapter;
import org.at4j.tar.builder.DirectoryViewDirectoryAdapter;
import org.at4j.tar.builder.FileDirectoryAdapter;
import org.at4j.tar.builder.TarBuilderConstants;
import org.at4j.tar.builder.TarBuilderSettings;
import org.at4j.tar.builder.TarEntrySettings;
import org.at4j.tar.builder.TarEntryStrategy;
import org.entityfs.DataSink;
import org.entityfs.DirectoryView;
import org.entityfs.RandomAccess;
import org.entityfs.RandomlyAccessibleFile;
import org.entityfs.ReadableFile;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.lock.DummyLock;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.support.io.RandomAccessMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarBuilder
extends AbstractStreamAddCapableArchiveBuilder<TarBuilder, TarEntrySettings> {
    private final RandomAccess m_targetRandomAccess;
    private final boolean m_closeRandomAccessWhenClosing;
    private final Lock m_targetWriteLock;
    private final TarEntryStrategy m_entryStrategy;
    private boolean m_closed = false;

    public TarBuilder(RandomlyAccessibleFile randomlyAccessibleFile) throws WrappedIOException {
        this(randomlyAccessibleFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TarBuilder(RandomlyAccessibleFile randomlyAccessibleFile, TarBuilderSettings tarBuilderSettings) throws WrappedIOException {
        super(tarBuilderSettings != null ? TarBuilderConstants.DEFAULT_DEFAULT_TAR_FILE_ENTRY_SETTINGS.combineWith(tarBuilderSettings.getDefaultFileEntrySettings()) : TarBuilderConstants.DEFAULT_DEFAULT_TAR_FILE_ENTRY_SETTINGS, tarBuilderSettings != null ? TarBuilderConstants.DEFAULT_DEFAULT_TAR_DIRECTORY_ENTRY_SETTINGS.combineWith(tarBuilderSettings.getDefaultDirectoryEntrySettings()) : TarBuilderConstants.DEFAULT_DEFAULT_TAR_DIRECTORY_ENTRY_SETTINGS);
        randomlyAccessibleFile.getClass();
        this.m_entryStrategy = tarBuilderSettings != null ? tarBuilderSettings.getEntryStrategy() : TarBuilderSettings.DEFAULT_ENTRY_STRATEGY;
        this.m_closeRandomAccessWhenClosing = true;
        RandomAccess randomAccess = null;
        boolean bl = false;
        this.m_targetWriteLock = randomlyAccessibleFile.lockForWriting();
        try {
            randomAccess = randomlyAccessibleFile.openForRandomAccess(RandomAccessMode.READ_WRITE);
            randomAccess.setLength(0L);
            bl = true;
            this.m_targetRandomAccess = randomAccess;
        }
        finally {
            if (!bl) {
                this.m_closed = true;
                this.m_targetWriteLock.unlock();
                if (randomAccess != null) {
                    randomAccess.close();
                }
            }
        }
    }

    public TarBuilder(RandomAccess randomAccess, TarBuilderSettings tarBuilderSettings) throws WrappedIOException {
        super(tarBuilderSettings != null ? TarBuilderConstants.DEFAULT_DEFAULT_TAR_FILE_ENTRY_SETTINGS.combineWith(tarBuilderSettings.getDefaultFileEntrySettings()) : TarBuilderConstants.DEFAULT_DEFAULT_TAR_FILE_ENTRY_SETTINGS, tarBuilderSettings != null ? TarBuilderConstants.DEFAULT_DEFAULT_TAR_DIRECTORY_ENTRY_SETTINGS.combineWith(tarBuilderSettings.getDefaultDirectoryEntrySettings()) : TarBuilderConstants.DEFAULT_DEFAULT_TAR_DIRECTORY_ENTRY_SETTINGS);
        randomAccess.getClass();
        this.m_entryStrategy = tarBuilderSettings != null ? tarBuilderSettings.getEntryStrategy() : TarBuilderSettings.DEFAULT_ENTRY_STRATEGY;
        this.m_closeRandomAccessWhenClosing = false;
        this.m_targetRandomAccess = randomAccess;
        this.m_targetWriteLock = DummyLock.INSTANCE;
    }

    @Override
    protected TarEntrySettings getDefaultDefaultDirectoryEntrySettings() {
        return TarBuilderConstants.DEFAULT_DEFAULT_TAR_DIRECTORY_ENTRY_SETTINGS;
    }

    @Override
    protected TarEntrySettings getDefaultDefaultFileEntrySettings() {
        return TarBuilderConstants.DEFAULT_DEFAULT_TAR_FILE_ENTRY_SETTINGS;
    }

    @Override
    protected void assertNotClosed() throws IllegalStateException {
        if (this.m_closed) {
            throw new IllegalStateException("This Tar builder is closed");
        }
    }

    @Override
    protected void addDirectoryCallback(AbsoluteLocation absoluteLocation, Object object, TarEntrySettings tarEntrySettings, Date date) throws WrappedIOException, ArchiveEntryAddException {
        DirectoryAdapter<DirectoryView> directoryAdapter;
        if (object instanceof DirectoryView) {
            directoryAdapter = new DirectoryViewDirectoryAdapter((DirectoryView)object);
        } else if (object instanceof File) {
            directoryAdapter = new FileDirectoryAdapter((File)object);
        } else {
            throw new ArchiveEntryAddException("Don't know how to adapt " + object + " to something that I can use");
        }
        this.m_entryStrategy.writeDirectory((DataSink)this.m_targetRandomAccess, directoryAdapter, absoluteLocation, tarEntrySettings, date);
    }

    @Override
    protected void addFileCallback(AbsoluteLocation absoluteLocation, ReadableFile readableFile, TarEntrySettings tarEntrySettings, Date date) throws WrappedIOException, ArchiveEntryAddException {
        this.m_entryStrategy.writeFile((DataSink)this.m_targetRandomAccess, readableFile, absoluteLocation, tarEntrySettings, date);
    }

    @Override
    protected void addStreamCallback(AbsoluteLocation absoluteLocation, InputStream inputStream, TarEntrySettings tarEntrySettings, Date date) throws WrappedIOException, ArchiveEntryAddException {
        this.m_entryStrategy.writeFileFromStream(this.m_targetRandomAccess, inputStream, absoluteLocation, tarEntrySettings, date);
    }

    @Override
    public boolean isClosed() {
        return this.m_closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws WrappedIOException {
        if (!this.m_closed) {
            try {
                try {
                    this.m_targetRandomAccess.write(new byte[1024]);
                }
                finally {
                    if (this.m_closeRandomAccessWhenClosing) {
                        this.m_targetRandomAccess.close();
                    }
                }
            }
            finally {
                this.m_targetWriteLock.unlock();
                this.m_closed = true;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (!this.m_closed) {
            this.close();
        }
        super.finalize();
    }
}

