/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.at4j.archive.builder.ArchiveEntrySettings;
import org.entityfs.entityattrs.unix.UnixEntityMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarEntrySettings
implements ArchiveEntrySettings<TarEntrySettings> {
    private static final int MAX_ID = 0x1FFFFF;
    private UnixEntityMode m_entityMode;
    private Integer m_ownerUid;
    private Integer m_ownerGid;
    private String m_ownerUserName;
    private String m_ownerGroupName;
    private Map<String, String> m_properties = new HashMap<String, String>();
    private boolean m_readOnly;

    private void assertNotReadOnly() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("This configuration object is read only");
        }
    }

    @Override
    public TarEntrySettings setReadOnly() {
        this.m_readOnly = true;
        return this;
    }

    public TarEntrySettings setEntityMode(UnixEntityMode unixEntityMode) throws IllegalStateException {
        this.assertNotReadOnly();
        this.m_entityMode = unixEntityMode;
        return this;
    }

    public UnixEntityMode getEntityMode() {
        return this.m_entityMode;
    }

    private void checkOwnerIdRange(Integer n) throws IllegalArgumentException {
        int n2;
        if (n != null && ((n2 = n.intValue()) < 0 || n2 > 0x1FFFFF)) {
            throw new IllegalArgumentException("Illegal UID or GID " + n2 + ". It must be between 0 and " + 0x1FFFFF + " (inclusive)");
        }
    }

    public TarEntrySettings setOwnerUid(Integer n) throws IllegalArgumentException, IllegalStateException {
        this.checkOwnerIdRange(n);
        this.assertNotReadOnly();
        this.m_ownerUid = n;
        return this;
    }

    public Integer getOwnerUid() {
        return this.m_ownerUid;
    }

    public TarEntrySettings setOwnerGid(Integer n) throws IllegalArgumentException, IllegalStateException {
        this.checkOwnerIdRange(n);
        this.assertNotReadOnly();
        this.m_ownerGid = n;
        return this;
    }

    public Integer getOwnerGid() {
        return this.m_ownerGid;
    }

    public TarEntrySettings setOwnerUserName(String string) throws IllegalStateException {
        this.assertNotReadOnly();
        this.m_ownerUserName = string;
        return this;
    }

    public String getOwnerUserName() {
        return this.m_ownerUserName;
    }

    public TarEntrySettings setOwnerGroupName(String string) throws IllegalStateException {
        this.assertNotReadOnly();
        this.m_ownerGroupName = string;
        return this;
    }

    public String getOwnerGroupName() {
        return this.m_ownerGroupName;
    }

    public TarEntrySettings addProperty(String string, String string2) throws IllegalStateException {
        this.assertNotReadOnly();
        string.getClass();
        string2.getClass();
        this.m_properties.put(string, string2);
        return this;
    }

    public String removeProperty(String string) throws IllegalStateException {
        this.assertNotReadOnly();
        return this.m_properties.remove(string);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.m_properties);
    }

    @Override
    public TarEntrySettings combineWith(TarEntrySettings tarEntrySettings) {
        TarEntrySettings tarEntrySettings2 = this.clone();
        if (tarEntrySettings.getEntityMode() != null) {
            tarEntrySettings2.setEntityMode(tarEntrySettings.getEntityMode());
        }
        if (tarEntrySettings.getOwnerUid() != null) {
            tarEntrySettings2.setOwnerUid(tarEntrySettings.getOwnerUid());
        }
        if (tarEntrySettings.getOwnerGid() != null) {
            tarEntrySettings2.setOwnerGid(tarEntrySettings.getOwnerGid());
        }
        if (tarEntrySettings.getOwnerUserName() != null) {
            tarEntrySettings2.setOwnerUserName(tarEntrySettings.getOwnerUserName());
        }
        if (tarEntrySettings.getOwnerGroupName() != null) {
            tarEntrySettings2.setOwnerGroupName(tarEntrySettings.getOwnerGroupName());
        }
        tarEntrySettings2.m_properties.putAll(tarEntrySettings.m_properties);
        return tarEntrySettings2;
    }

    @Override
    public TarEntrySettings clone() {
        try {
            TarEntrySettings tarEntrySettings = (TarEntrySettings)super.clone();
            tarEntrySettings.m_readOnly = false;
            tarEntrySettings.m_properties = new HashMap<String, String>();
            tarEntrySettings.m_properties.putAll(this.m_properties);
            return tarEntrySettings;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Bug", cloneNotSupportedException);
        }
    }
}

