/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar.builder;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.at4j.archive.builder.AbstractArchiveBuilder;
import org.at4j.archive.builder.ArchiveEntryAddException;
import org.at4j.tar.builder.DirectoryAdapter;
import org.at4j.tar.builder.DirectoryViewDirectoryAdapter;
import org.at4j.tar.builder.FileDirectoryAdapter;
import org.at4j.tar.builder.TarBuilderConstants;
import org.at4j.tar.builder.TarBuilderSettings;
import org.at4j.tar.builder.TarEntrySettings;
import org.at4j.tar.builder.TarEntryStrategy;
import org.entityfs.DataSink;
import org.entityfs.DirectoryView;
import org.entityfs.ReadableFile;
import org.entityfs.WritableFile;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.lock.DummyLock;
import org.entityfs.lock.EntityLock;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.util.io.OutputStreamToDataSinkAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarStreamBuilder
extends AbstractArchiveBuilder<TarStreamBuilder, TarEntrySettings> {
    private final DataSink m_out;
    private final boolean m_closeOutStreamWhenClosing;
    private final EntityLock m_targetWriteLock;
    private final TarEntryStrategy m_entryStrategy;
    private boolean m_closed = false;

    public TarStreamBuilder(WritableFile writableFile) throws WrappedIOException {
        this(writableFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TarStreamBuilder(WritableFile writableFile, TarBuilderSettings tarBuilderSettings) throws WrappedIOException {
        super(tarBuilderSettings != null ? TarBuilderConstants.DEFAULT_DEFAULT_TAR_FILE_ENTRY_SETTINGS.combineWith(tarBuilderSettings.getDefaultFileEntrySettings()) : TarBuilderConstants.DEFAULT_DEFAULT_TAR_FILE_ENTRY_SETTINGS, tarBuilderSettings != null ? TarBuilderConstants.DEFAULT_DEFAULT_TAR_DIRECTORY_ENTRY_SETTINGS.combineWith(tarBuilderSettings.getDefaultDirectoryEntrySettings()) : TarBuilderConstants.DEFAULT_DEFAULT_TAR_DIRECTORY_ENTRY_SETTINGS);
        writableFile.getClass();
        this.m_entryStrategy = tarBuilderSettings != null ? tarBuilderSettings.getEntryStrategy() : TarBuilderSettings.DEFAULT_ENTRY_STRATEGY;
        this.m_closeOutStreamWhenClosing = true;
        boolean bl = false;
        BufferedOutputStream bufferedOutputStream = null;
        this.m_targetWriteLock = writableFile.lockForWriting();
        try {
            bufferedOutputStream = new BufferedOutputStream(writableFile.openForWrite());
            this.m_out = new OutputStreamToDataSinkAdapter((OutputStream)bufferedOutputStream);
            bl = true;
        }
        finally {
            if (!bl) {
                this.m_closed = true;
                this.m_targetWriteLock.unlock();
                if (bufferedOutputStream != null) {
                    try {
                        ((OutputStream)bufferedOutputStream).close();
                    }
                    catch (IOException iOException) {
                        throw new WrappedIOException(iOException);
                    }
                }
            }
        }
    }

    public TarStreamBuilder(OutputStream outputStream, TarBuilderSettings tarBuilderSettings) throws WrappedIOException {
        super(tarBuilderSettings != null ? TarBuilderConstants.DEFAULT_DEFAULT_TAR_FILE_ENTRY_SETTINGS.combineWith(tarBuilderSettings.getDefaultFileEntrySettings()) : TarBuilderConstants.DEFAULT_DEFAULT_TAR_FILE_ENTRY_SETTINGS, tarBuilderSettings != null ? TarBuilderConstants.DEFAULT_DEFAULT_TAR_DIRECTORY_ENTRY_SETTINGS.combineWith(tarBuilderSettings.getDefaultDirectoryEntrySettings()) : TarBuilderConstants.DEFAULT_DEFAULT_TAR_DIRECTORY_ENTRY_SETTINGS);
        outputStream.getClass();
        this.m_out = new OutputStreamToDataSinkAdapter(outputStream);
        this.m_entryStrategy = tarBuilderSettings != null ? tarBuilderSettings.getEntryStrategy() : TarBuilderSettings.DEFAULT_ENTRY_STRATEGY;
        this.m_closeOutStreamWhenClosing = false;
        this.m_targetWriteLock = DummyLock.INSTANCE;
    }

    @Override
    protected TarEntrySettings getDefaultDefaultDirectoryEntrySettings() {
        return TarBuilderConstants.DEFAULT_DEFAULT_TAR_DIRECTORY_ENTRY_SETTINGS;
    }

    @Override
    protected TarEntrySettings getDefaultDefaultFileEntrySettings() {
        return TarBuilderConstants.DEFAULT_DEFAULT_TAR_FILE_ENTRY_SETTINGS;
    }

    @Override
    protected void assertNotClosed() throws IllegalStateException {
        if (this.m_closed) {
            throw new IllegalStateException("This Tar builder is closed");
        }
    }

    @Override
    protected void addDirectoryCallback(AbsoluteLocation absoluteLocation, Object object, TarEntrySettings tarEntrySettings, Date date) throws WrappedIOException, ArchiveEntryAddException {
        DirectoryAdapter<DirectoryView> directoryAdapter;
        if (object instanceof DirectoryView) {
            directoryAdapter = new DirectoryViewDirectoryAdapter((DirectoryView)object);
        } else if (object instanceof File) {
            directoryAdapter = new FileDirectoryAdapter((File)object);
        } else {
            throw new ArchiveEntryAddException("Don't know how to adapt " + object + " to something that I can use");
        }
        this.m_entryStrategy.writeDirectory(this.m_out, directoryAdapter, absoluteLocation, tarEntrySettings, date);
    }

    @Override
    protected void addFileCallback(AbsoluteLocation absoluteLocation, ReadableFile readableFile, TarEntrySettings tarEntrySettings, Date date) throws WrappedIOException, ArchiveEntryAddException {
        this.m_entryStrategy.writeFile(this.m_out, readableFile, absoluteLocation, tarEntrySettings, date);
    }

    @Override
    public boolean isClosed() {
        return this.m_closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws WrappedIOException {
        if (!this.m_closed) {
            try {
                try {
                    this.m_out.write(new byte[1024]);
                }
                finally {
                    if (this.m_closeOutStreamWhenClosing) {
                        this.m_out.close();
                    }
                }
            }
            finally {
                this.m_targetWriteLock.unlock();
                this.m_closed = true;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (!this.m_closed) {
            this.close();
        }
        super.finalize();
    }
}

