/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar.builder;

import java.nio.charset.Charset;
import java.util.Date;
import org.at4j.archive.builder.ArchiveEntryAddException;
import org.at4j.support.nio.charset.Charsets;
import org.at4j.tar.builder.TarEntrySettings;
import org.at4j.tar.builder.V7TarEntryStrategy;
import org.entityfs.ETDirectory;
import org.entityfs.ETFile;
import org.entityfs.EntityType;

public class UstarEntryStrategy
extends V7TarEntryStrategy {
    private static final byte[] MAGIC_BYTES = "ustar".getBytes();
    private static final byte[] VERSION_BYTES = "00".getBytes();
    private static final byte FILE_TYPE = 48;
    private static final byte DIRECTORY_TYPE = 53;

    public UstarEntryStrategy() {
    }

    public UstarEntryStrategy(Charset charset) {
        super(charset);
    }

    protected void setFileNameInHeader(byte[] byArray, String string) throws ArchiveEntryAddException {
        byte[] byArray2 = Charsets.getBytes(string, this.getTextEncodingCharset());
        if (byArray2.length < 100) {
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        } else {
            int n = string.lastIndexOf(47);
            if (n < 0) {
                throw new ArchiveEntryAddException("The name " + string + " does not fit in the name header");
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            byte[] byArray3 = Charsets.getBytes(string2, this.getTextEncodingCharset());
            byte[] byArray4 = Charsets.getBytes(string3, this.getTextEncodingCharset());
            if (byArray3.length > 155 || byArray4.length > 99) {
                throw new ArchiveEntryAddException("The name " + string + " does not fit in the name header");
            }
            System.arraycopy(byArray4, 0, byArray, 0, byArray4.length);
            System.arraycopy(byArray3, 0, byArray, 345, byArray3.length);
        }
    }

    protected byte[] getHeader(Object object, String string, TarEntrySettings tarEntrySettings, long l, EntityType entityType, Date date) throws ArchiveEntryAddException {
        byte[] byArray = super.getHeader(object, string, tarEntrySettings, l, entityType, date);
        if (entityType == ETFile.TYPE) {
            byArray[156] = 48;
        } else if (entityType == ETDirectory.TYPE) {
            byArray[156] = 53;
        } else {
            throw new ArchiveEntryAddException("The entity type " + entityType + " of entity " + object + " is not supported");
        }
        System.arraycopy(MAGIC_BYTES, 0, byArray, 257, 5);
        byArray[263] = VERSION_BYTES[0];
        byArray[264] = VERSION_BYTES[1];
        byte[] byArray2 = Charsets.getBytes(tarEntrySettings.getOwnerUserName(), this.getTextEncodingCharset());
        System.arraycopy(byArray2, 0, byArray, 265, Math.min(32, byArray2.length));
        byte[] byArray3 = Charsets.getBytes(tarEntrySettings.getOwnerGroupName(), this.getTextEncodingCharset());
        System.arraycopy(byArray3, 0, byArray, 297, Math.min(32, byArray3.length));
        return byArray;
    }
}

