/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import org.at4j.archive.builder.ArchiveEntryAddException;
import org.at4j.support.nio.charset.Charsets;
import org.at4j.tar.builder.DirectoryAdapter;
import org.at4j.tar.builder.TarEntrySettings;
import org.at4j.tar.builder.TarEntryStrategy;
import org.entityfs.DataSink;
import org.entityfs.ETDirectory;
import org.entityfs.ETFile;
import org.entityfs.EntityType;
import org.entityfs.RandomAccess;
import org.entityfs.ReadableFile;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.support.io.StreamUtil;
import org.entityfs.util.io.DataSinkToOutputStreamAdapter;
import org.entityfs.util.io.RandomAccessToOutputStreamAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V7TarEntryStrategy
implements TarEntryStrategy {
    private static final byte[] ZEROED_BLOCK = new byte[512];
    private final Charset m_textEncodingCharset;

    public V7TarEntryStrategy() {
        this.m_textEncodingCharset = Charset.defaultCharset();
    }

    public V7TarEntryStrategy(Charset charset) {
        charset.getClass();
        this.m_textEncodingCharset = charset;
    }

    protected final Charset getTextEncodingCharset() {
        return this.m_textEncodingCharset;
    }

    protected byte[] zeroPadLeft(String string, int n) {
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, (byte)48);
        byte[] byArray2 = string.getBytes();
        System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
        return byArray;
    }

    protected void goToNextBlockBoundary(DataSink dataSink, long l) throws WrappedIOException {
        long l2;
        int n;
        if (l > 0L && (n = (int)((l2 = ((l - 1L) / 512L + 1L) * 512L) - l)) > 0) {
            dataSink.write(ZEROED_BLOCK, 0, n);
        }
    }

    protected String getFileName(AbsoluteLocation absoluteLocation, boolean bl) {
        String string = absoluteLocation.getLocation().substring(1);
        if (bl) {
            string = string + "/";
        }
        return string;
    }

    protected void setFileNameInHeader(byte[] byArray, String string) throws ArchiveEntryAddException {
        byte[] byArray2 = Charsets.getBytes(string, this.m_textEncodingCharset);
        if (byArray2.length > 99) {
            throw new ArchiveEntryAddException("The entity name " + string + " is longer than 99 bytes when encoded in the " + this.m_textEncodingCharset + " charset");
        }
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
    }

    protected byte[] getHeader(Object object, String string, TarEntrySettings tarEntrySettings, long l, EntityType entityType, Date date) throws ArchiveEntryAddException {
        byte[] byArray = new byte[512];
        this.setFileNameInHeader(byArray, string);
        System.arraycopy(this.zeroPadLeft(Integer.toOctalString(tarEntrySettings.getEntityMode().getCode()), 7), 0, byArray, 100, 7);
        System.arraycopy(this.zeroPadLeft(Integer.toOctalString(tarEntrySettings.getOwnerUid()), 7), 0, byArray, 108, 7);
        System.arraycopy(this.zeroPadLeft(Integer.toOctalString(tarEntrySettings.getOwnerGid()), 7), 0, byArray, 116, 7);
        System.arraycopy(this.zeroPadLeft(Long.toOctalString(l), 11), 0, byArray, 124, 11);
        long l2 = date.getTime() / 1000L;
        System.arraycopy(this.zeroPadLeft(Long.toOctalString(l2), 11), 0, byArray, 136, 11);
        byte[] byArray2 = new byte[7];
        Arrays.fill(byArray2, (byte)48);
        System.arraycopy(byArray2, 0, byArray, 329, 7);
        System.arraycopy(byArray2, 0, byArray, 337, 7);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long writeFileToArchive(DataSink dataSink, ReadableFile readableFile, TarEntrySettings tarEntrySettings) throws WrappedIOException {
        long l;
        InputStream inputStream = readableFile.openForRead();
        try {
            l = StreamUtil.copyStreams((InputStream)inputStream, (OutputStream)new DataSinkToOutputStreamAdapter(dataSink), (int)16384);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new WrappedIOException(iOException);
            }
        }
        inputStream.close();
        return l;
    }

    protected byte[] addChecksumToHeader(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += byArray[i] & 0xFF;
        }
        System.arraycopy(this.zeroPadLeft(Long.toOctalString(n += 256), 6), 0, byArray, 148, 6);
        byArray[155] = 32;
        return byArray;
    }

    @Override
    public void writeFile(DataSink dataSink, ReadableFile readableFile, AbsoluteLocation absoluteLocation, TarEntrySettings tarEntrySettings, Date date) {
        byte[] byArray = this.getHeader(readableFile, this.getFileName(absoluteLocation, false), tarEntrySettings, readableFile.getDataSize(), (EntityType)ETFile.TYPE, date);
        this.addChecksumToHeader(byArray);
        dataSink.write(byArray);
        long l = this.writeFileToArchive(dataSink, readableFile, tarEntrySettings);
        this.goToNextBlockBoundary(dataSink, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFileFromStream(RandomAccess randomAccess, InputStream inputStream, AbsoluteLocation absoluteLocation, TarEntrySettings tarEntrySettings, Date date) {
        long l = randomAccess.getFilePointer();
        long l2 = 0L;
        boolean bl = false;
        try {
            randomAccess.seek(l + 512L);
            l2 = StreamUtil.copyStreams((InputStream)inputStream, (OutputStream)new RandomAccessToOutputStreamAdapter(randomAccess, false), (int)16384);
            long l3 = randomAccess.getFilePointer();
            byte[] byArray = this.getHeader(inputStream, this.getFileName(absoluteLocation, false), tarEntrySettings, l2, (EntityType)ETFile.TYPE, date);
            this.addChecksumToHeader(byArray);
            randomAccess.seek(l);
            randomAccess.write(byArray);
            randomAccess.seek(l3);
            bl = true;
        }
        finally {
            if (bl) {
                this.goToNextBlockBoundary((DataSink)randomAccess, l2);
            } else {
                randomAccess.setLength(l);
                randomAccess.seek(l);
            }
        }
    }

    @Override
    public void writeDirectory(DataSink dataSink, DirectoryAdapter<?> directoryAdapter, AbsoluteLocation absoluteLocation, TarEntrySettings tarEntrySettings, Date date) {
        dataSink.write(this.addChecksumToHeader(this.getHeader(directoryAdapter, this.getFileName(absoluteLocation, true), tarEntrySettings, 0L, (EntityType)ETDirectory.TYPE, date)));
    }
}

