/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar.prog;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.at4j.comp.bzip2.BZip2ReadableFile;
import org.at4j.comp.bzip2.BZip2ReadableFileSettings;
import org.at4j.comp.bzip2.BZip2WritableFile;
import org.at4j.comp.bzip2.BZip2WritableFileSettings;
import org.at4j.comp.lzma.LzmaReadableFile;
import org.at4j.comp.lzma.LzmaWritableFile;
import org.at4j.support.prog.AbstractProgram;
import org.at4j.support.prog.CommandErrorException;
import org.at4j.tar.PrintTarEntryExtractionStrategy;
import org.at4j.tar.TarExtractSpecification;
import org.at4j.tar.TarExtractor;
import org.at4j.tar.builder.GnuTarEntryStrategy;
import org.at4j.tar.builder.PaxTarEntryStrategy;
import org.at4j.tar.builder.TarBuilderSettings;
import org.at4j.tar.builder.TarStreamBuilder;
import org.at4j.tar.builder.UstarEntryStrategy;
import org.at4j.tar.builder.V7TarEntryStrategy;
import org.at4j.tar.prog.TarCommand;
import org.at4j.tar.prog.TarCommandLineArguments;
import org.entityfs.Directory;
import org.entityfs.DirectoryView;
import org.entityfs.ReadableFile;
import org.entityfs.WritableFile;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.fs.FSRWFileSystemBuilder;
import org.entityfs.ostrat.DontOverwriteAndLogWarning;
import org.entityfs.ostrat.OverwriteStrategy;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.util.FileReadableFile;
import org.entityfs.util.io.GZipReadableFile;
import org.entityfs.util.io.GZipWritableFile;
import org.entityfs.util.io.ReadWritableFileAdapter;

public final class Tar
extends AbstractProgram {
    private boolean parseCondensedCommand(String string, TarCommandLineArguments tarCommandLineArguments) throws CommandErrorException {
        char c = string.charAt(0);
        if (c == 'x') {
            tarCommandLineArguments.setCommand(TarCommand.EXTRACT);
        } else if (c == 't') {
            tarCommandLineArguments.setCommand(TarCommand.LIST);
        } else if (c == 'c') {
            tarCommandLineArguments.setCommand(TarCommand.CREATE);
        } else {
            throw new CommandErrorException("Unknown command: " + c);
        }
        boolean bl = false;
        for (int i = 1; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == 'f') {
                bl = true;
                continue;
            }
            if (c2 == 'z') {
                tarCommandLineArguments.setGZip();
                continue;
            }
            if (c2 == 'j') {
                tarCommandLineArguments.setBZip2();
                continue;
            }
            throw new CommandErrorException("Unknown Tar option: " + c2);
        }
        return bl;
    }

    private void verifyAllMandatorySettingsPresent(TarCommandLineArguments tarCommandLineArguments) throws CommandErrorException {
        if (tarCommandLineArguments.getTarFile() == null) {
            throw new CommandErrorException("Missing Tar file");
        }
        if (tarCommandLineArguments.getFilesToTar().isEmpty()) {
            if (tarCommandLineArguments.getCommand() == TarCommand.CREATE) {
                throw new CommandErrorException("Missing files to add to archive");
            }
        } else if (tarCommandLineArguments.getCommand() != TarCommand.CREATE) {
            throw new CommandErrorException("Don't know what to do with " + tarCommandLineArguments.getTarFile());
        }
    }

    private int parseOption(String string, String[] stringArray, int n, TarCommandLineArguments tarCommandLineArguments) throws CommandErrorException {
        if ("-f".equals(string) || "--file".equals(string)) {
            tarCommandLineArguments.setTarFile(new File(this.getArg(stringArray, n, "Missing Tar file")));
            return 1;
        }
        if ("-z".equals(string) || "--gzip".equals(string)) {
            tarCommandLineArguments.setGZip();
            return 0;
        }
        if ("-j".equals(string) || "--bzip2".equals(string)) {
            tarCommandLineArguments.setBZip2();
            return 0;
        }
        if ("--lzma".equals(string)) {
            tarCommandLineArguments.setLzma();
            return 0;
        }
        if ("--timing".equals(string)) {
            tarCommandLineArguments.setTiming();
            return 0;
        }
        if ("--charset".equals(string)) {
            tarCommandLineArguments.setCharset(Charset.forName(this.getArg(stringArray, n, "Missing charset name")));
            return 1;
        }
        if ("-k".equals(string) || "--keep-old-files".equals(string)) {
            tarCommandLineArguments.setOverwriteStrategy((OverwriteStrategy)DontOverwriteAndLogWarning.INSTANCE);
            return 0;
        }
        if (string.startsWith("--format=")) {
            tarCommandLineArguments.setArchiveFormat(string.substring(9));
            return 0;
        }
        if ("-H".equals(string)) {
            tarCommandLineArguments.setArchiveFormat(this.getArg(stringArray, n, "Missing archive format"));
            return 1;
        }
        throw new CommandErrorException("Unknown option: " + string);
    }

    private TarCommandLineArguments parseCommandLine(String[] stringArray) throws CommandErrorException {
        boolean bl;
        String string;
        TarCommandLineArguments tarCommandLineArguments = new TarCommandLineArguments();
        int n = 0;
        if ((string = this.getArg(stringArray, n++, "Missing command")).charAt(0) != '-') {
            bl = this.parseCondensedCommand(string, tarCommandLineArguments);
            if (bl) {
                string = this.getArg(stringArray, n++, "Missing file");
                tarCommandLineArguments.setTarFile(new File(string));
            }
        } else if ("-c".equals(string)) {
            tarCommandLineArguments.setCommand(TarCommand.CREATE);
        } else if ("-t".equals(string)) {
            tarCommandLineArguments.setCommand(TarCommand.LIST);
        } else if ("-x".equals(string)) {
            tarCommandLineArguments.setCommand(TarCommand.EXTRACT);
        } else {
            throw new CommandErrorException("Unknown command: " + string);
        }
        bl = true;
        while (n < stringArray.length) {
            string = stringArray[n++];
            if (bl) {
                if (string.startsWith("-")) {
                    n += this.parseOption(string, stringArray, n, tarCommandLineArguments);
                } else {
                    bl = false;
                }
            }
            if (bl) continue;
            tarCommandLineArguments.addFileToTar(new File(string));
        }
        this.verifyAllMandatorySettingsPresent(tarCommandLineArguments);
        return tarCommandLineArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(TarCommandLineArguments tarCommandLineArguments) throws CommandErrorException, IOException {
        File file = tarCommandLineArguments.getTarFile();
        if (file.exists() && !file.delete()) {
            throw new CommandErrorException("Could not delete " + file);
        }
        if (!file.createNewFile()) {
            throw new CommandErrorException("Could not create target file " + file);
        }
        Object object = new ReadWritableFileAdapter(file);
        if (tarCommandLineArguments.isGZip()) {
            object = new GZipWritableFile((WritableFile)object);
        } else if (tarCommandLineArguments.isBZip2()) {
            object = new BZip2WritableFile((WritableFile)object, new BZip2WritableFileSettings().setBlockSize(9));
        } else if (tarCommandLineArguments.isLzma()) {
            object = new LzmaWritableFile((WritableFile)object);
        }
        TarBuilderSettings tarBuilderSettings = new TarBuilderSettings();
        if ("gnu".equals(tarCommandLineArguments.getArchiveFormat())) {
            tarBuilderSettings.setEntryStrategy(new GnuTarEntryStrategy(tarCommandLineArguments.getCharset()));
        } else if ("v7".equals(tarCommandLineArguments.getArchiveFormat())) {
            tarBuilderSettings.setEntryStrategy(new V7TarEntryStrategy(tarCommandLineArguments.getCharset()));
        } else if ("ustar".equals(tarCommandLineArguments.getArchiveFormat())) {
            tarBuilderSettings.setEntryStrategy(new UstarEntryStrategy(tarCommandLineArguments.getCharset()));
        } else if ("posix".equals(tarCommandLineArguments.getArchiveFormat())) {
            tarBuilderSettings.setEntryStrategy(new PaxTarEntryStrategy(tarCommandLineArguments.getCharset()));
        } else {
            throw new CommandErrorException("Unknown archive format: " + tarCommandLineArguments.getArchiveFormat());
        }
        TarStreamBuilder tarStreamBuilder = new TarStreamBuilder((WritableFile)object, tarBuilderSettings);
        try {
            for (File file2 : tarCommandLineArguments.getFilesToTar()) {
                AbsoluteLocation absoluteLocation = this.getParentLocation(file2);
                tarStreamBuilder.addRecursively(file2, absoluteLocation.getChildLocation(file2.getName()));
            }
        }
        finally {
            tarStreamBuilder.close();
        }
    }

    private ReadableFile getTarFile(TarCommandLineArguments tarCommandLineArguments) throws CommandErrorException {
        File file = tarCommandLineArguments.getTarFile();
        if (!file.exists()) {
            throw new CommandErrorException(file + " does not exist");
        }
        if (!file.isFile()) {
            throw new CommandErrorException(file + " is not a file");
        }
        Object object = new FileReadableFile(file);
        if (tarCommandLineArguments.isGZip()) {
            object = new GZipReadableFile((ReadableFile)object);
        } else if (tarCommandLineArguments.isBZip2()) {
            object = new BZip2ReadableFile((ReadableFile)object, new BZip2ReadableFileSettings().setBufferSize(4096));
        } else if (tarCommandLineArguments.isLzma()) {
            object = new LzmaReadableFile((ReadableFile)object);
        }
        return object;
    }

    private void extract(TarCommandLineArguments tarCommandLineArguments) throws CommandErrorException, IOException {
        Directory directory = ((FSRWFileSystemBuilder)((FSRWFileSystemBuilder)((FSRWFileSystemBuilder)new FSRWFileSystemBuilder().disableAccessControls()).disableEntityValidityControls()).setRoot(new File("."))).create().getRootDirectory();
        ReadableFile readableFile = this.getTarFile(tarCommandLineArguments);
        TarExtractSpecification tarExtractSpecification = new TarExtractSpecification();
        tarExtractSpecification.setFileNameCharset(tarCommandLineArguments.getCharset());
        tarExtractSpecification.setOverwriteStrategy(tarCommandLineArguments.getOverwriteStrategy());
        new TarExtractor(readableFile).extract((DirectoryView)directory, tarExtractSpecification);
    }

    private void list(TarCommandLineArguments tarCommandLineArguments) throws CommandErrorException, IOException {
        ReadableFile readableFile = this.getTarFile(tarCommandLineArguments);
        TarExtractSpecification tarExtractSpecification = new TarExtractSpecification();
        tarExtractSpecification.setFileNameCharset(tarCommandLineArguments.getCharset());
        tarExtractSpecification.setEntryExtractionStrategy(new PrintTarEntryExtractionStrategy(System.out));
        new TarExtractor(readableFile).extract((DirectoryView)null, tarExtractSpecification);
    }

    private void run(String[] stringArray) throws CommandErrorException, IOException {
        TarCommandLineArguments tarCommandLineArguments = this.parseCommandLine(stringArray);
        long l = System.currentTimeMillis();
        switch (tarCommandLineArguments.getCommand()) {
            case EXTRACT: {
                this.extract(tarCommandLineArguments);
                break;
            }
            case CREATE: {
                this.create(tarCommandLineArguments);
                break;
            }
            case LIST: {
                this.list(tarCommandLineArguments);
                break;
            }
            default: {
                throw new CommandErrorException("Bug: unknown command " + (Object)((Object)tarCommandLineArguments.getCommand()));
            }
        }
        long l2 = System.currentTimeMillis();
        if (tarCommandLineArguments.isTiming()) {
            System.out.println("The operation took " + (l2 - l) + " ms.");
            System.out.println("The time it took to load Java and start the program is not included.");
        }
    }

    public static void main(String[] stringArray) {
        try {
            new Tar().run(stringArray);
        }
        catch (CommandErrorException commandErrorException) {
            System.err.println(commandErrorException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(1);
        }
        catch (WrappedIOException wrappedIOException) {
            System.err.println(wrappedIOException.getMessage());
            System.exit(1);
        }
    }
}

