/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.tar.prog;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.at4j.tar.prog.TarCommand;
import org.entityfs.ostrat.DoOverwriteAndLogWarning;
import org.entityfs.ostrat.OverwriteStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TarCommandLineArguments {
    private TarCommand m_command;
    private boolean m_gzip;
    private boolean m_bzip2;
    private boolean m_lzma;
    private File m_tarFile;
    private List<File> m_filesToTar = new ArrayList<File>();
    private boolean m_timing;
    private Charset m_charset = Charset.defaultCharset();
    private OverwriteStrategy m_overwriteStrategy = DoOverwriteAndLogWarning.INSTANCE;
    private String m_archiveFormat = "gnu";

    TarCommandLineArguments() {
    }

    void setCommand(TarCommand tarCommand) {
        this.m_command = tarCommand;
    }

    TarCommand getCommand() {
        return this.m_command;
    }

    boolean isGZip() {
        return this.m_gzip;
    }

    void setGZip() {
        this.m_gzip = true;
    }

    boolean isBZip2() {
        return this.m_bzip2;
    }

    void setBZip2() {
        this.m_bzip2 = true;
    }

    boolean isLzma() {
        return this.m_lzma;
    }

    void setLzma() {
        this.m_lzma = true;
    }

    void setTarFile(File file) {
        this.m_tarFile = file;
    }

    File getTarFile() {
        return this.m_tarFile;
    }

    void addFileToTar(File file) {
        this.m_filesToTar.add(file);
    }

    List<File> getFilesToTar() {
        return this.m_filesToTar;
    }

    void setTiming() {
        this.m_timing = true;
    }

    boolean isTiming() {
        return this.m_timing;
    }

    void setCharset(Charset charset) {
        this.m_charset = charset;
    }

    Charset getCharset() {
        return this.m_charset;
    }

    void setOverwriteStrategy(OverwriteStrategy overwriteStrategy) {
        this.m_overwriteStrategy = overwriteStrategy;
    }

    OverwriteStrategy getOverwriteStrategy() {
        return this.m_overwriteStrategy;
    }

    void setArchiveFormat(String string) {
        this.m_archiveFormat = string;
    }

    String getArchiveFormat() {
        return this.m_archiveFormat;
    }
}

