/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.util.archive;

import java.io.File;
import java.util.Map;
import org.at4j.archive.Archive;
import org.at4j.archive.ArchiveDirectoryEntry;
import org.at4j.archive.ArchiveEntry;
import org.at4j.archive.ArchiveFileEntry;
import org.at4j.archive.ArchiveSymbolicLinkEntry;
import org.at4j.support.entityfs.ExistingDirectory;
import org.at4j.support.entityfs.FutureDirectory;
import org.at4j.support.entityfs.PotentialDirectory;
import org.at4j.util.archive.ExtractSpecification;
import org.entityfs.Directory;
import org.entityfs.DirectoryView;
import org.entityfs.FileSystem;
import org.entityfs.exception.EntityNotFoundException;
import org.entityfs.exception.NotADirectoryException;
import org.entityfs.fs.FSRWFileSystemBuilder;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.support.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveExtractor {
    private final Archive<?, ?> m_archive;

    public ArchiveExtractor(Archive<?, ?> archive) {
        archive.getClass();
        this.m_archive = archive;
    }

    private void extractDirectory(ArchiveDirectoryEntry<?, ?> archiveDirectoryEntry, PotentialDirectory potentialDirectory, ExtractSpecification extractSpecification) {
        Filter<? super ArchiveEntry<?, ?>> filter = extractSpecification.getFilter();
        for (Map.Entry<String, ?> entry : archiveDirectoryEntry.getChildEntries().entrySet()) {
            ArchiveEntry archiveEntry = (ArchiveEntry)entry.getValue();
            PotentialDirectory potentialDirectory2 = null;
            boolean bl = false;
            if (filter == null || filter.matches((Object)archiveEntry)) {
                bl = true;
                if (archiveEntry instanceof ArchiveFileEntry) {
                    extractSpecification.getEntryExtractionStrategy().extractFile((ArchiveFileEntry)archiveEntry, potentialDirectory, extractSpecification);
                } else if (archiveEntry instanceof ArchiveDirectoryEntry) {
                    Directory directory = extractSpecification.getEntryExtractionStrategy().extractDirectory((ArchiveDirectoryEntry)archiveEntry, potentialDirectory, extractSpecification);
                    if (directory != null) {
                        potentialDirectory2 = new ExistingDirectory(directory);
                    }
                } else if (archiveEntry instanceof ArchiveSymbolicLinkEntry) {
                    extractSpecification.getEntryExtractionStrategy().extractSymbolicLink((ArchiveSymbolicLinkEntry)archiveEntry, potentialDirectory, extractSpecification);
                } else {
                    System.err.println("Don't know how to extract the entry " + archiveEntry + ". This entry will be ignored!");
                }
            }
            if (!(archiveEntry instanceof ArchiveDirectoryEntry)) continue;
            if (!bl) {
                potentialDirectory2 = new FutureDirectory(potentialDirectory, archiveEntry.getName(), extractSpecification.getOverwriteStrategy(), System.currentTimeMillis());
            }
            if (potentialDirectory2 == null) continue;
            this.extractDirectory((ArchiveDirectoryEntry)archiveEntry, potentialDirectory2, extractSpecification);
            if (!bl) continue;
            extractSpecification.getEntryExtractionStrategy().postProcessDirectory((ArchiveDirectoryEntry)archiveEntry, ((ExistingDirectory)potentialDirectory2).getDirectory(), extractSpecification);
        }
    }

    public void extract(DirectoryView directoryView) throws WrappedIOException {
        this.extractDirectory((ArchiveDirectoryEntry<?, ?>)this.m_archive.getRootEntry(), new ExistingDirectory((Directory)directoryView.getViewedEntity()), new ExtractSpecification());
    }

    public void extract(DirectoryView directoryView, ExtractSpecification extractSpecification) throws WrappedIOException {
        this.extractDirectory((ArchiveDirectoryEntry<?, ?>)this.m_archive.getRootEntry(), new ExistingDirectory((Directory)directoryView.getViewedEntity()), extractSpecification);
    }

    private FileSystem getTargetFileSystem(File file) throws EntityNotFoundException, NotADirectoryException {
        if (!file.exists()) {
            throw new EntityNotFoundException("The target directory " + file + " does not exist");
        }
        if (!file.isDirectory()) {
            throw new NotADirectoryException("The target " + file + " is not a directory");
        }
        return ((FSRWFileSystemBuilder)((FSRWFileSystemBuilder)((FSRWFileSystemBuilder)new FSRWFileSystemBuilder().disableAccessControls()).disableEntityValidityControls()).setRoot(file)).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(File file) throws WrappedIOException, EntityNotFoundException, NotADirectoryException {
        FileSystem fileSystem = this.getTargetFileSystem(file);
        try {
            this.extractDirectory((ArchiveDirectoryEntry<?, ?>)this.m_archive.getRootEntry(), new ExistingDirectory(fileSystem.getRootDirectory()), new ExtractSpecification());
        }
        finally {
            fileSystem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(File file, ExtractSpecification extractSpecification) throws WrappedIOException, EntityNotFoundException, NotADirectoryException {
        FileSystem fileSystem = this.getTargetFileSystem(file);
        try {
            this.extractDirectory((ArchiveDirectoryEntry<?, ?>)this.m_archive.getRootEntry(), new ExistingDirectory(fileSystem.getRootDirectory()), extractSpecification);
        }
        finally {
            fileSystem.close();
        }
    }
}

