/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.util.archive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.at4j.archive.ArchiveDirectoryEntry;
import org.at4j.archive.ArchiveEntry;
import org.at4j.archive.ArchiveFileEntry;
import org.at4j.archive.ArchiveSymbolicLinkEntry;
import org.at4j.support.entityfs.PotentialDirectory;
import org.at4j.tar.TarEntry;
import org.at4j.util.archive.EntryExtractionStrategy;
import org.at4j.util.archive.ExtractSpecification;
import org.at4j.zip.ZipEntry;
import org.entityfs.Directory;
import org.entityfs.EFile;
import org.entityfs.ETDirectory;
import org.entityfs.ETFile;
import org.entityfs.Entity;
import org.entityfs.EntityType;
import org.entityfs.lock.EntityLock;
import org.entityfs.ostrat.OverwriteResult;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.support.io.StreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryExtractor
implements EntryExtractionStrategy {
    public static final EntryExtractor INSTANCE = new EntryExtractor();

    private void setLastModificationTime(ArchiveEntry<?, ?> archiveEntry, Entity entity) {
        if (archiveEntry instanceof TarEntry) {
            entity.setLastModified(((TarEntry)archiveEntry).getLastModificationTime().getTime());
        } else if (archiveEntry instanceof ZipEntry) {
            entity.setLastModified(((ZipEntry)archiveEntry).getLastModified().getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Directory extractDirectory(ArchiveDirectoryEntry<?, ?> archiveDirectoryEntry, PotentialDirectory potentialDirectory, ExtractSpecification extractSpecification) {
        Directory directory = potentialDirectory.getDirectory();
        if (directory == null) {
            return null;
        }
        String string = archiveDirectoryEntry.getName();
        EntityLock entityLock = directory.lockForWriting();
        try {
            switch (extractSpecification.getOverwriteStrategy().overwrite(directory, string, (EntityType)ETDirectory.TYPE)) {
                case CAN_CREATE_NEW_ENTITY: {
                    Directory directory2 = (Directory)directory.newEntity((EntityType)ETDirectory.TYPE, string, null);
                    return directory2;
                }
                case KEPT_OLD_DIRECTORY: {
                    Directory directory3 = (Directory)directory.getEntityOrNull(string);
                    directory3.getClass();
                    Directory directory4 = directory3;
                    return directory4;
                }
            }
            Directory directory5 = null;
            return directory5;
        }
        finally {
            entityLock.unlock();
        }
    }

    @Override
    public void postProcessDirectory(ArchiveDirectoryEntry<?, ?> archiveDirectoryEntry, Directory directory, ExtractSpecification extractSpecification) {
        if (extractSpecification.isPreserveModificationTimes()) {
            this.setLastModificationTime(archiveDirectoryEntry, (Entity)directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractFile(ArchiveFileEntry<?, ?> archiveFileEntry, PotentialDirectory potentialDirectory, ExtractSpecification extractSpecification) {
        block17: {
            Directory directory = potentialDirectory.getDirectory();
            if (directory != null) {
                String string = archiveFileEntry.getName();
                EntityLock entityLock = directory.lockForWriting();
                try {
                    if (extractSpecification.getOverwriteStrategy().overwrite(directory, string, (EntityType)ETFile.TYPE) != OverwriteResult.CAN_CREATE_NEW_ENTITY) break block17;
                    EFile eFile = (EFile)directory.newEntity((EntityType)ETFile.TYPE, string, null);
                    EntityLock entityLock2 = eFile.lockForWriting();
                    try {
                        entityLock.unlock();
                        entityLock = null;
                        try {
                            InputStream inputStream = archiveFileEntry.openForRead();
                            try {
                                OutputStream outputStream = eFile.openForWrite();
                                try {
                                    StreamUtil.copyStreams((InputStream)inputStream, (OutputStream)outputStream, (int)eFile.getFileSystem().getBufferSize(), (long)archiveFileEntry.getDataSize());
                                }
                                finally {
                                    outputStream.close();
                                }
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            throw new WrappedIOException(iOException);
                        }
                        if (extractSpecification.isPreserveModificationTimes()) {
                            this.setLastModificationTime(archiveFileEntry, (Entity)eFile);
                        }
                    }
                    finally {
                        entityLock2.unlock();
                    }
                }
                finally {
                    if (entityLock != null) {
                        entityLock.unlock();
                    }
                }
            }
        }
    }

    @Override
    public void extractSymbolicLink(ArchiveSymbolicLinkEntry<?, ?> archiveSymbolicLinkEntry, PotentialDirectory potentialDirectory, ExtractSpecification extractSpecification) {
        System.err.println("Ignoring symbolic link " + archiveSymbolicLinkEntry.getLocation() + " -> " + archiveSymbolicLinkEntry.getLinkTarget());
    }
}

