/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.util.archive;

import java.io.PrintStream;
import org.at4j.archive.ArchiveDirectoryEntry;
import org.at4j.archive.ArchiveFileEntry;
import org.at4j.archive.ArchiveSymbolicLinkEntry;
import org.at4j.support.entityfs.PotentialDirectory;
import org.at4j.util.archive.EntryExtractionStrategy;
import org.at4j.util.archive.ExtractSpecification;
import org.entityfs.Directory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintingEntryExtractor
implements EntryExtractionStrategy {
    private final PrintStream m_out;

    public PrintingEntryExtractor() {
        this.m_out = System.out;
    }

    public PrintingEntryExtractor(PrintStream printStream) {
        printStream.getClass();
        this.m_out = printStream;
    }

    @Override
    public Directory extractDirectory(ArchiveDirectoryEntry<?, ?> archiveDirectoryEntry, PotentialDirectory potentialDirectory, ExtractSpecification extractSpecification) {
        this.m_out.println("d " + archiveDirectoryEntry.getLocation());
        return null;
    }

    @Override
    public void postProcessDirectory(ArchiveDirectoryEntry<?, ?> archiveDirectoryEntry, Directory directory, ExtractSpecification extractSpecification) {
    }

    @Override
    public void extractFile(ArchiveFileEntry<?, ?> archiveFileEntry, PotentialDirectory potentialDirectory, ExtractSpecification extractSpecification) {
        this.m_out.println("f " + archiveFileEntry.getLocation());
    }

    @Override
    public void extractSymbolicLink(ArchiveSymbolicLinkEntry<?, ?> archiveSymbolicLinkEntry, PotentialDirectory potentialDirectory, ExtractSpecification extractSpecification) {
        this.m_out.println("l " + archiveSymbolicLinkEntry.getLocation() + " -> " + archiveSymbolicLinkEntry.getLinkTarget());
    }
}

