/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.at4j.archive.AbstractArchiveEntry;
import org.at4j.support.lang.UnsignedByte;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.zip.ZipDirectoryEntry;
import org.at4j.zip.ZipEntryCentralFileHeaderData;
import org.at4j.zip.ZipEntryCollaborator;
import org.at4j.zip.ZipEntryLocalFileHeaderData;
import org.at4j.zip.ZipGeneralPurposeBitFlags;
import org.at4j.zip.ef.ZipEntryExtraField;
import org.at4j.zip.extattrs.MsDosExternalFileAttributes;
import org.at4j.zip.extattrs.ZipExternalFileAttributes;
import org.entityfs.el.AbsoluteLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ZipEntry
extends AbstractArchiveEntry<ZipEntry, ZipDirectoryEntry> {
    private static final UnsignedByte DEFAULT_VERSION_USED_TO_CREATE = UnsignedByte.valueOf(10);
    private static final UnsignedByte DEFAULT_VERSION_NEEDED_TO_EXTRACT = UnsignedByte.valueOf(10);
    private static final ZipGeneralPurposeBitFlags DEFAULT_GENERAL_PURPOSE_BIT_FLAGS = new ZipGeneralPurposeBitFlags();
    private static final UnsignedShort DEFAULT_DISK_NUMBER_START = UnsignedShort.valueOf(0);
    private final ZipExternalFileAttributes m_externalFileAttributes;
    private final UnsignedByte m_versionUsedToCreate;
    private final UnsignedByte m_versionNeededToExtract;
    private final ZipGeneralPurposeBitFlags m_generalPurposeBitFlags;
    private final Date m_lastModificationTime;
    private final UnsignedShort m_diskNumberStart;
    private final Collection<ZipEntryExtraField> m_extraFields;
    private final String m_comment;

    protected ZipEntry(ZipEntryCollaborator zipEntryCollaborator, AbsoluteLocation absoluteLocation) {
        super(absoluteLocation, zipEntryCollaborator);
        this.m_externalFileAttributes = MsDosExternalFileAttributes.DEFAULT_DIRECTORY_ATTRIBUTES;
        this.m_versionUsedToCreate = DEFAULT_VERSION_USED_TO_CREATE;
        this.m_versionNeededToExtract = DEFAULT_VERSION_NEEDED_TO_EXTRACT;
        this.m_generalPurposeBitFlags = DEFAULT_GENERAL_PURPOSE_BIT_FLAGS;
        this.m_lastModificationTime = new Date();
        this.m_diskNumberStart = DEFAULT_DISK_NUMBER_START;
        this.m_extraFields = Collections.emptyList();
        this.m_comment = "";
    }

    protected ZipEntry(ZipEntryCollaborator zipEntryCollaborator, ZipEntryCentralFileHeaderData zipEntryCentralFileHeaderData, ZipEntryLocalFileHeaderData zipEntryLocalFileHeaderData) {
        super(zipEntryCentralFileHeaderData.getLocation(), zipEntryCollaborator);
        zipEntryCentralFileHeaderData.getClass();
        this.m_externalFileAttributes = zipEntryCentralFileHeaderData.getExternalFileAttributes();
        this.m_versionUsedToCreate = zipEntryCentralFileHeaderData.getVersionUsedToCreate();
        this.m_versionNeededToExtract = zipEntryCentralFileHeaderData.getVersionNeededToExtract();
        this.m_generalPurposeBitFlags = zipEntryCentralFileHeaderData.getGeneralPurposeBitFlags();
        this.m_lastModificationTime = zipEntryCentralFileHeaderData.getLastModificationTime();
        this.m_diskNumberStart = zipEntryCentralFileHeaderData.getDiskNumberStart();
        ArrayList<ZipEntryExtraField> arrayList = new ArrayList<ZipEntryExtraField>(zipEntryCentralFileHeaderData.getExtraFields().size() + zipEntryLocalFileHeaderData.getExtraFields().size());
        arrayList.addAll(zipEntryCentralFileHeaderData.getExtraFields());
        arrayList.addAll(zipEntryLocalFileHeaderData.getExtraFields());
        this.m_extraFields = Collections.unmodifiableList(arrayList);
        this.m_comment = zipEntryCentralFileHeaderData.getFileComment();
    }

    public UnsignedByte getVersionUsedToCreate() {
        return this.m_versionUsedToCreate;
    }

    public UnsignedByte getVersionNeededToExtract() {
        return this.m_versionNeededToExtract;
    }

    public ZipGeneralPurposeBitFlags getGeneralPurposeBitFlags() {
        return this.m_generalPurposeBitFlags;
    }

    public boolean isEncrypted() {
        return this.m_generalPurposeBitFlags.isEncrypted();
    }

    public boolean isStrongEncryption() {
        return this.m_generalPurposeBitFlags.isStrongEncryption();
    }

    public Date getLastModified() {
        return this.m_lastModificationTime != null ? new Date(this.m_lastModificationTime.getTime()) : null;
    }

    public UnsignedShort getDiskNumberStart() {
        return this.m_diskNumberStart;
    }

    public ZipExternalFileAttributes getExternalFileAttributes() {
        return this.m_externalFileAttributes;
    }

    public Collection<ZipEntryExtraField> getExtraFields() {
        return this.m_extraFields;
    }

    public <T> T getExtraField(Class<T> clazz, boolean bl) {
        for (ZipEntryExtraField zipEntryExtraField : this.m_extraFields) {
            if (zipEntryExtraField.isInLocalHeader() != bl || !clazz.isAssignableFrom(zipEntryExtraField.getClass())) continue;
            return (T)zipEntryExtraField;
        }
        return null;
    }

    public String getComment() {
        return this.m_comment;
    }
}

