/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.at4j.archive.Archive;
import org.at4j.zip.ZipDirectoryEntry;
import org.at4j.zip.ZipEntry;
import org.at4j.zip.ZipEntryCollaborator;
import org.at4j.zip.ZipFileContents;
import org.at4j.zip.ZipFileParseException;
import org.at4j.zip.ZipFileParser;
import org.entityfs.RandomAccess;
import org.entityfs.RandomlyAccessibleFile;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.support.io.RandomAccessMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFile
implements Archive<ZipEntry, ZipDirectoryEntry> {
    private final RandomlyAccessibleFile m_backingFile;
    private final Lock m_zipFileReadLock;
    private final Map<AbsoluteLocation, ZipEntry> m_entries;
    private final ZipDirectoryEntry m_rootEntry;
    private final ZipEntryCollaborator m_entryCollaborator;
    private final String m_comment;
    private final AtomicBoolean m_closed;

    public ZipFile(RandomlyAccessibleFile randomlyAccessibleFile) throws ZipFileParseException, WrappedIOException {
        this(randomlyAccessibleFile, Charset.defaultCharset(), Charset.defaultCharset(), new ZipFileParser());
    }

    public ZipFile(RandomlyAccessibleFile randomlyAccessibleFile, Charset charset, Charset charset2) throws ZipFileParseException, WrappedIOException {
        this(randomlyAccessibleFile, charset, charset2, new ZipFileParser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFile(RandomlyAccessibleFile randomlyAccessibleFile, Charset charset, Charset charset2, ZipFileParser zipFileParser) throws ZipFileParseException, WrappedIOException {
        randomlyAccessibleFile.getClass();
        zipFileParser.getClass();
        charset.getClass();
        charset2.getClass();
        boolean bl = false;
        this.m_backingFile = randomlyAccessibleFile;
        this.m_zipFileReadLock = randomlyAccessibleFile.lockForReading();
        try {
            this.m_entryCollaborator = new ZipEntryCollaborator(randomlyAccessibleFile, this);
            RandomAccess randomAccess = randomlyAccessibleFile.openForRandomAccess(RandomAccessMode.READ_ONLY);
            try {
                if (randomAccess.length() == 0L) {
                    this.m_rootEntry = new ZipDirectoryEntry(this.m_entryCollaborator, AbsoluteLocation.ROOT_DIR, Collections.EMPTY_MAP);
                    this.m_entries = Collections.singletonMap(AbsoluteLocation.ROOT_DIR, this.m_rootEntry);
                    this.m_comment = "";
                } else {
                    ZipFileContents zipFileContents = zipFileParser.parse(this.m_entryCollaborator, randomAccess, charset, charset2);
                    this.m_entries = Collections.unmodifiableMap(zipFileContents.getEntryMap());
                    this.m_rootEntry = zipFileContents.getRootEntry();
                    this.m_comment = zipFileContents.getComment();
                    bl = true;
                }
            }
            finally {
                randomAccess.close();
            }
        }
        finally {
            if (!bl) {
                this.m_zipFileReadLock.unlock();
            }
        }
        this.m_closed = new AtomicBoolean(false);
    }

    protected void assertNotClosed() throws IllegalStateException {
        if (this.m_closed.get()) {
            throw new IllegalStateException("This Zip file is closed");
        }
    }

    @Override
    public ZipDirectoryEntry getRootEntry() throws IllegalStateException {
        this.assertNotClosed();
        return this.m_rootEntry;
    }

    public String getComment() throws IllegalStateException {
        this.assertNotClosed();
        return this.m_comment;
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object object) throws IllegalStateException {
        this.assertNotClosed();
        return this.m_entries.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) throws IllegalStateException {
        this.assertNotClosed();
        return this.m_entries.containsValue(object);
    }

    @Override
    public Set<Map.Entry<AbsoluteLocation, ZipEntry>> entrySet() throws IllegalStateException {
        this.assertNotClosed();
        return this.m_entries.entrySet();
    }

    @Override
    public ZipEntry get(Object object) throws IllegalStateException {
        this.assertNotClosed();
        return this.m_entries.get(object);
    }

    @Override
    public boolean isEmpty() throws IllegalStateException {
        this.assertNotClosed();
        return false;
    }

    @Override
    public Set<AbsoluteLocation> keySet() throws IllegalStateException {
        this.assertNotClosed();
        return this.m_entries.keySet();
    }

    @Override
    public ZipEntry put(AbsoluteLocation absoluteLocation, ZipEntry zipEntry) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends AbsoluteLocation, ? extends ZipEntry> map) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ZipEntry remove(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() throws IllegalStateException {
        this.assertNotClosed();
        return this.m_entries.size();
    }

    @Override
    public Collection<ZipEntry> values() throws IllegalStateException {
        this.assertNotClosed();
        return this.m_entries.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.m_closed.getAndSet(true)) {
            try {
                this.m_entryCollaborator.close();
            }
            finally {
                this.m_zipFileReadLock.unlock();
            }
        }
    }

    public RandomlyAccessibleFile getBackingFile() {
        return this.m_backingFile;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

