/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ScatteringByteChannel;
import org.at4j.archive.ArchiveFileEntry;
import org.at4j.support.lang.UnsignedInteger;
import org.at4j.zip.ZipDirectoryEntry;
import org.at4j.zip.ZipEntry;
import org.at4j.zip.ZipEntryCentralFileHeaderData;
import org.at4j.zip.ZipEntryCollaborator;
import org.at4j.zip.ZipEntryLocalFileHeaderData;
import org.at4j.zip.ZipFileParseException;
import org.at4j.zip.ZipInternalFileAttributes;
import org.at4j.zip.comp.UnsupportedCompressionMethodException;
import org.at4j.zip.comp.ZipEntryCompressionMethod;
import org.entityfs.RandomAccess;
import org.entityfs.exception.LockTimeoutException;
import org.entityfs.exception.ReadOnlyException;
import org.entityfs.lock.DummyLock;
import org.entityfs.lock.EntityLock;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.support.io.RandomAccessMode;
import org.entityfs.support.io.ScatteringByteChannelAdapter;
import org.entityfs.util.base.EmptyRandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileEntry
extends ZipEntry
implements ArchiveFileEntry<ZipEntry, ZipDirectoryEntry> {
    private final long m_startPosOfFileData;
    private final ZipEntryCompressionMethod m_compressionMethod;
    private final UnsignedInteger m_uncompressedSize;
    private final UnsignedInteger m_compressedSize;
    private final UnsignedInteger m_crc32;
    private final ZipInternalFileAttributes m_internalFileAttributes;

    public ZipFileEntry(ZipEntryCollaborator zipEntryCollaborator, ZipEntryCentralFileHeaderData zipEntryCentralFileHeaderData, ZipEntryLocalFileHeaderData zipEntryLocalFileHeaderData) {
        super(zipEntryCollaborator, zipEntryCentralFileHeaderData, zipEntryLocalFileHeaderData);
        this.m_compressionMethod = zipEntryCentralFileHeaderData.getCompressionMethod();
        this.m_startPosOfFileData = zipEntryLocalFileHeaderData.getStartPositionOfFileData();
        this.m_uncompressedSize = zipEntryCentralFileHeaderData.getUncompressedSize();
        this.m_compressedSize = zipEntryCentralFileHeaderData.getCompressedSize();
        this.m_crc32 = zipEntryCentralFileHeaderData.getCrc32();
        this.m_internalFileAttributes = zipEntryCentralFileHeaderData.getInternalFileAttributes();
    }

    public boolean isCompressedPatchData() {
        return this.getGeneralPurposeBitFlags().isCompressedPatchedData();
    }

    public ZipEntryCompressionMethod getCompressionMethod() {
        return this.m_compressionMethod;
    }

    public long getDataSize() {
        return this.m_uncompressedSize.longValue();
    }

    public UnsignedInteger getUncompressedSize() {
        return this.m_uncompressedSize;
    }

    public UnsignedInteger getCompressedSize() {
        return this.m_compressedSize;
    }

    public long getSize() {
        return this.m_compressedSize.longValue();
    }

    public UnsignedInteger getCrc32() {
        return this.m_crc32;
    }

    public boolean isAppearingToBeTextFile() {
        return this.m_internalFileAttributes.isTextFile();
    }

    public EntityLock lockForWriting() throws LockTimeoutException {
        return DummyLock.INSTANCE;
    }

    public EntityLock getWriteLock() {
        return DummyLock.INSTANCE;
    }

    public boolean isWriteLockedByCurrentThread() {
        return true;
    }

    public ScatteringByteChannel openChannelForRead() throws UnsupportedOperationException {
        return new ScatteringByteChannelAdapter(Channels.newChannel(this.openForRead()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openForRead() throws UnsupportedCompressionMethodException, ZipFileParseException {
        InputStream inputStream;
        block7: {
            if (this.m_compressedSize.intValue() == 0) {
                return new ByteArrayInputStream(new byte[0]);
            }
            boolean bl = false;
            InputStream inputStream2 = this.getCollaborator().openStream(this.m_startPosOfFileData, this.m_startPosOfFileData + this.m_compressedSize.longValue() - 1L);
            try {
                InputStream inputStream3 = this.m_compressionMethod.createInputStream(inputStream2, this.m_compressedSize.longValue(), this.m_uncompressedSize.longValue());
                bl = true;
                inputStream = inputStream3;
                if (bl) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (!bl) {
                        inputStream2.close();
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new ZipFileParseException(iOException);
                }
            }
            inputStream2.close();
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccess openForRandomAccess(RandomAccessMode randomAccessMode) throws UnsupportedCompressionMethodException, UnsupportedOperationException, ZipFileParseException {
        RandomAccess randomAccess;
        block9: {
            if (randomAccessMode != RandomAccessMode.READ_ONLY) {
                throw new ReadOnlyException("A Zip entry is read only");
            }
            if (!this.m_compressionMethod.isRandomAccessSupported()) {
                throw new UnsupportedOperationException("Random access is not supported for files compressed with the " + this.m_compressionMethod + " compression method");
            }
            if (this.m_compressedSize.intValue() == 0) {
                return new EmptyRandomAccess();
            }
            boolean bl = false;
            RandomAccess randomAccess2 = this.getCollaborator().openRandomAccess(this.m_startPosOfFileData, this.m_startPosOfFileData + this.m_compressedSize.longValue() - 1L);
            try {
                RandomAccess randomAccess3 = this.m_compressionMethod.createRandomAccess(randomAccess2, this.m_compressedSize.longValue(), this.m_uncompressedSize.longValue());
                bl = true;
                randomAccess = randomAccess3;
                if (bl) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (!bl) {
                        randomAccess2.close();
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new WrappedIOException(iOException);
                }
            }
            randomAccess2.close();
        }
        return randomAccess;
    }

    public String toString() {
        return this.getName();
    }
}

