/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.at4j.support.lang.UnsignedByte;
import org.at4j.support.lang.UnsignedInteger;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.support.nio.charset.Charsets;
import org.at4j.support.util.MsDosDate;
import org.at4j.support.util.MsDosTime;
import org.at4j.zip.ZipDirectoryEntry;
import org.at4j.zip.ZipEntry;
import org.at4j.zip.ZipEntryCentralFileHeaderData;
import org.at4j.zip.ZipEntryCollaborator;
import org.at4j.zip.ZipEntryLocalFileHeaderData;
import org.at4j.zip.ZipFileContents;
import org.at4j.zip.ZipFileEntry;
import org.at4j.zip.ZipFileParseException;
import org.at4j.zip.ZipGeneralPurposeBitFlags;
import org.at4j.zip.ZipInternalFileAttributes;
import org.at4j.zip.ZipSymbolicLinkEntry;
import org.at4j.zip.ZipVersionMadeBy;
import org.at4j.zip.comp.ZipEntryCompressionMethodRegistry;
import org.at4j.zip.ef.ZipEntryExtraField;
import org.at4j.zip.ef.ZipEntryExtraFieldParser;
import org.at4j.zip.ef.ZipEntryExtraFieldParserRegistry;
import org.at4j.zip.extattrs.UnixEntityType;
import org.at4j.zip.extattrs.UnixExternalFileAttributes;
import org.at4j.zip.extattrs.ZipExternalFileAttributesParserRegistry;
import org.entityfs.RandomAccess;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.exception.UnexpectedEofException;
import org.entityfs.support.exception.WrappedIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileParser {
    protected static final long LOCAL_FILE_HEADER = 67324752L;
    protected static final long CENTRAL_FILE_HEADER = 33639248L;
    private static final int[] END_OF_CENTRAL_DIRECTORY_HEADER_BACKWARDS = new int[]{6, 5, 75, 80};
    private static final int BYTES_TO_SCAN_FOR_END_OF_CENTRAL_DIRECTORY_HEADER_BEFORE_GIVING_UP = 67000;
    private ZipEntryExtraFieldParserRegistry m_extraFieldParserRegistry = new ZipEntryExtraFieldParserRegistry();
    private ZipEntryCompressionMethodRegistry m_compressionMethodRegistry = new ZipEntryCompressionMethodRegistry();
    private ZipExternalFileAttributesParserRegistry m_externalFileAttrFactoryRegistry = new ZipExternalFileAttributesParserRegistry();

    public ZipEntryCompressionMethodRegistry getCompressionMethodRegistry() {
        return this.m_compressionMethodRegistry;
    }

    public void setCompressionMethodRegistry(ZipEntryCompressionMethodRegistry zipEntryCompressionMethodRegistry) {
        zipEntryCompressionMethodRegistry.getClass();
        this.m_compressionMethodRegistry = zipEntryCompressionMethodRegistry;
    }

    public ZipExternalFileAttributesParserRegistry getExternalFileAttributesParserRegistry() {
        return this.m_externalFileAttrFactoryRegistry;
    }

    public void setExternalFileAttributesParserRegistry(ZipExternalFileAttributesParserRegistry zipExternalFileAttributesParserRegistry) {
        zipExternalFileAttributesParserRegistry.getClass();
        this.m_externalFileAttrFactoryRegistry = zipExternalFileAttributesParserRegistry;
    }

    public ZipEntryExtraFieldParserRegistry getExtraFieldParserRegistry() {
        return this.m_extraFieldParserRegistry;
    }

    public void setExtraFieldParserRegistry(ZipEntryExtraFieldParserRegistry zipEntryExtraFieldParserRegistry) {
        zipEntryExtraFieldParserRegistry.getClass();
        this.m_extraFieldParserRegistry = zipEntryExtraFieldParserRegistry;
    }

    protected boolean isLocalFileHeader(UnsignedInteger unsignedInteger) {
        return unsignedInteger != null && unsignedInteger.longValue() == 67324752L;
    }

    protected boolean isCentralFileHeader(UnsignedInteger unsignedInteger) {
        return unsignedInteger != null && unsignedInteger.longValue() == 33639248L;
    }

    protected void assertIsCentralFileHeader(UnsignedInteger unsignedInteger, RandomAccess randomAccess) throws ZipFileParseException {
        if (unsignedInteger.longValue() != 33639248L) {
            throw new ZipFileParseException("Parse error at position " + (randomAccess.getFilePointer() - 4L) + ". Expected a central file header");
        }
    }

    protected String readString(RandomAccess randomAccess, int n, Charset charset, boolean bl) throws UnexpectedEofException {
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[n];
        int n2 = randomAccess.read(byArray);
        if (n2 != n) {
            throw new UnexpectedEofException("Wanted to read " + n + " bytes. Got " + n2);
        }
        return (bl ? Charsets.UTF8.decode(ByteBuffer.wrap(byArray)) : charset.decode(ByteBuffer.wrap(byArray))).toString();
    }

    protected byte[] readByteArray(RandomAccess randomAccess, int n) throws UnexpectedEofException {
        if (n == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n];
        int n2 = randomAccess.read(byArray);
        if (n2 != n) {
            throw new UnexpectedEofException("Wanted to read " + n + " bytes. Got " + n2);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ZipEntryExtraField> parseExtraFields(byte[] byArray, boolean bl) {
        if (byArray.length < 4) {
            return new ArrayList<ZipEntryExtraField>(0);
        }
        ArrayList<ZipEntryExtraField> arrayList = new ArrayList<ZipEntryExtraField>(3);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                while (((InputStream)byteArrayInputStream).available() > 0) {
                    int n;
                    UnsignedShort unsignedShort = UnsignedShort.readBigEndian(byteArrayInputStream);
                    UnsignedShort unsignedShort2 = UnsignedShort.readBigEndian(byteArrayInputStream);
                    byte[] byArray2 = new byte[unsignedShort2.intValue()];
                    if (unsignedShort2.intValue() > 0 && (n = byteArrayInputStream.read(byArray2)) != unsignedShort2.intValue()) {
                        throw new ZipFileParseException("Wanted to read " + unsignedShort2 + " bytes of extra field data. Got " + n);
                    }
                    ZipEntryExtraFieldParser zipEntryExtraFieldParser = this.m_extraFieldParserRegistry.forCode(unsignedShort);
                    arrayList.add(zipEntryExtraFieldParser.parse(byArray2, bl));
                }
            }
            finally {
                ((InputStream)byteArrayInputStream).close();
            }
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
        return arrayList;
    }

    private ZipEntryCentralFileHeaderData readCentralFileHeader(RandomAccess randomAccess, Charset charset, Charset charset2) {
        boolean bl = false;
        ZipEntryCentralFileHeaderData zipEntryCentralFileHeaderData = new ZipEntryCentralFileHeaderData();
        zipEntryCentralFileHeaderData.setVersionUsedToCreate(UnsignedByte.read(randomAccess));
        ZipVersionMadeBy zipVersionMadeBy = ZipVersionMadeBy.valueOf(UnsignedByte.read(randomAccess));
        zipEntryCentralFileHeaderData.setVersionNeededToExtract(UnsignedByte.valueOf(UnsignedShort.readBigEndian(randomAccess).intValue()));
        zipEntryCentralFileHeaderData.setGeneralPurposeBitFlags(new ZipGeneralPurposeBitFlags(UnsignedShort.readBigEndian(randomAccess)));
        zipEntryCentralFileHeaderData.setCompressionMethod(this.m_compressionMethodRegistry.forCode(UnsignedShort.readBigEndian(randomAccess)).create(zipEntryCentralFileHeaderData.getGeneralPurposeBitFlags()));
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        MsDosTime.parseMsDosTime(UnsignedShort.readBigEndian(randomAccess), calendar);
        MsDosDate.parseMsDosDate(UnsignedShort.readBigEndian(randomAccess), calendar);
        zipEntryCentralFileHeaderData.setLastModificationTime(calendar.getTime());
        zipEntryCentralFileHeaderData.setCrc32(UnsignedInteger.readBigEndian(randomAccess));
        zipEntryCentralFileHeaderData.setCompressedSize(UnsignedInteger.readBigEndian(randomAccess));
        zipEntryCentralFileHeaderData.setUncompressedSize(UnsignedInteger.readBigEndian(randomAccess));
        UnsignedShort unsignedShort = UnsignedShort.readBigEndian(randomAccess);
        UnsignedShort unsignedShort2 = UnsignedShort.readBigEndian(randomAccess);
        UnsignedShort unsignedShort3 = UnsignedShort.readBigEndian(randomAccess);
        zipEntryCentralFileHeaderData.setDiskNumberStart(UnsignedShort.readBigEndian(randomAccess));
        zipEntryCentralFileHeaderData.setInternalFileAttributes(new ZipInternalFileAttributes(UnsignedShort.readBigEndian(randomAccess)));
        byte[] byArray = new byte[4];
        int n = randomAccess.read(byArray);
        if (n != 4) {
            throw new ZipFileParseException("Wanted to read 4 bytes. Got " + n);
        }
        zipEntryCentralFileHeaderData.setExternalFileAttributes(this.m_externalFileAttrFactoryRegistry.forVersionMadeBy(zipVersionMadeBy).parse(zipVersionMadeBy, byArray));
        zipEntryCentralFileHeaderData.setRelativeOffsetOfLocalHeader(UnsignedInteger.readBigEndian(randomAccess));
        boolean bl2 = zipEntryCentralFileHeaderData.getGeneralPurposeBitFlags().isUtf8Encoding();
        String string = this.readString(randomAccess, unsignedShort.intValue(), charset, bl2);
        if ("/".equals(string)) {
            bl = true;
        } else if (string.endsWith("/")) {
            zipEntryCentralFileHeaderData.setDirectory(true);
            string = string.substring(0, string.length() - 1);
        } else {
            zipEntryCentralFileHeaderData.setDirectory(false);
        }
        zipEntryCentralFileHeaderData.setLocation(new AbsoluteLocation("/" + string));
        zipEntryCentralFileHeaderData.setExtraFields(this.parseExtraFields(this.readByteArray(randomAccess, unsignedShort2.intValue()), false));
        zipEntryCentralFileHeaderData.setFileComment(this.readString(randomAccess, unsignedShort3.intValue(), charset2, bl2));
        return bl ? null : zipEntryCentralFileHeaderData;
    }

    private void placeEntryInTree(ZipEntityHolder zipEntityHolder, LinkedList<String> linkedList, ZipEntryCentralFileHeaderData zipEntryCentralFileHeaderData, ZipEntryLocalFileHeaderData zipEntryLocalFileHeaderData) {
        int n = linkedList.size();
        if (linkedList.size() == 1) {
            String string = linkedList.get(0);
            ZipEntityHolder zipEntityHolder2 = (ZipEntityHolder)zipEntityHolder.m_childEntities.get(string);
            if (zipEntityHolder2 == null) {
                zipEntityHolder2 = new ZipEntityHolder();
                zipEntityHolder.m_childEntities.put(string, zipEntityHolder2);
            }
            zipEntityHolder2.m_zecd = zipEntryCentralFileHeaderData;
            zipEntityHolder2.m_zeld = zipEntryLocalFileHeaderData;
        } else if (n != 0) {
            String string = linkedList.poll();
            ZipEntityHolder zipEntityHolder3 = (ZipEntityHolder)zipEntityHolder.m_childEntities.get(string);
            if (zipEntityHolder3 == null) {
                zipEntityHolder3 = new ZipEntityHolder();
                zipEntityHolder.m_childEntities.put(string, zipEntityHolder3);
            }
            this.placeEntryInTree(zipEntityHolder3, linkedList, zipEntryCentralFileHeaderData, zipEntryLocalFileHeaderData);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ZipDirectoryEntry createNonEmptyDirectoryEntry(ZipEntryCollaborator zipEntryCollaborator, ZipEntityHolder zipEntityHolder, AbsoluteLocation absoluteLocation, Map<AbsoluteLocation, ZipEntry> map, Charset charset) {
        void var8_11;
        HashMap<String, ZipEntry> hashMap = new HashMap<String, ZipEntry>(zipEntityHolder.m_childEntities.size());
        for (Map.Entry object2 : zipEntityHolder.m_childEntities.entrySet()) {
            hashMap.put((String)object2.getKey(), this.createEntries(zipEntryCollaborator, (ZipEntityHolder)object2.getValue(), absoluteLocation.getChildLocation((String)object2.getKey()), map, charset));
        }
        ZipEntryCentralFileHeaderData zipEntryCentralFileHeaderData = zipEntityHolder.m_zecd;
        if (zipEntryCentralFileHeaderData != null) {
            if (zipEntryCentralFileHeaderData.getUncompressedSize().longValue() > 0L) {
                System.err.println("The Zip entry " + absoluteLocation + " has both child entries and file data. The file data will be invisible");
            }
            ZipDirectoryEntry zipDirectoryEntry = new ZipDirectoryEntry(zipEntryCollaborator, zipEntryCentralFileHeaderData, zipEntityHolder.m_zeld, hashMap);
        } else {
            ZipDirectoryEntry zipDirectoryEntry = new ZipDirectoryEntry(zipEntryCollaborator, absoluteLocation, hashMap);
        }
        map.put(absoluteLocation, (ZipEntry)var8_11);
        return var8_11;
    }

    private ZipDirectoryEntry createEmptyDirectoryEntry(ZipEntryCollaborator zipEntryCollaborator, ZipEntryCentralFileHeaderData zipEntryCentralFileHeaderData, ZipEntryLocalFileHeaderData zipEntryLocalFileHeaderData, AbsoluteLocation absoluteLocation, Map<AbsoluteLocation, ZipEntry> map) {
        ZipDirectoryEntry zipDirectoryEntry = new ZipDirectoryEntry(zipEntryCollaborator, zipEntryCentralFileHeaderData, zipEntryLocalFileHeaderData, null);
        map.put(absoluteLocation, zipDirectoryEntry);
        return zipDirectoryEntry;
    }

    private ZipFileEntry createFileEntry(ZipEntryCollaborator zipEntryCollaborator, ZipEntryCentralFileHeaderData zipEntryCentralFileHeaderData, ZipEntryLocalFileHeaderData zipEntryLocalFileHeaderData, AbsoluteLocation absoluteLocation, Map<AbsoluteLocation, ZipEntry> map) {
        ZipFileEntry zipFileEntry = new ZipFileEntry(zipEntryCollaborator, zipEntryCentralFileHeaderData, zipEntryLocalFileHeaderData);
        map.put(absoluteLocation, zipFileEntry);
        return zipFileEntry;
    }

    private ZipSymbolicLinkEntry createSymbolicLinkEntry(ZipEntryCollaborator zipEntryCollaborator, ZipEntryCentralFileHeaderData zipEntryCentralFileHeaderData, ZipEntryLocalFileHeaderData zipEntryLocalFileHeaderData, AbsoluteLocation absoluteLocation, Map<AbsoluteLocation, ZipEntry> map, Charset charset) {
        ZipSymbolicLinkEntry zipSymbolicLinkEntry = new ZipSymbolicLinkEntry(zipEntryCollaborator, zipEntryCentralFileHeaderData, zipEntryLocalFileHeaderData, charset);
        map.put(absoluteLocation, zipSymbolicLinkEntry);
        return zipSymbolicLinkEntry;
    }

    private ZipEntry createEntries(ZipEntryCollaborator zipEntryCollaborator, ZipEntityHolder zipEntityHolder, AbsoluteLocation absoluteLocation, Map<AbsoluteLocation, ZipEntry> map, Charset charset) {
        if (zipEntityHolder.m_childEntities.size() > 0) {
            return this.createNonEmptyDirectoryEntry(zipEntryCollaborator, zipEntityHolder, absoluteLocation, map, charset);
        }
        if (absoluteLocation.equals((Object)AbsoluteLocation.ROOT_DIR)) {
            ZipDirectoryEntry zipDirectoryEntry = new ZipDirectoryEntry(zipEntryCollaborator, absoluteLocation, Collections.EMPTY_MAP);
            map.put(AbsoluteLocation.ROOT_DIR, zipDirectoryEntry);
            return zipDirectoryEntry;
        }
        ZipEntryCentralFileHeaderData zipEntryCentralFileHeaderData = zipEntityHolder.m_zecd;
        if (zipEntryCentralFileHeaderData == null) {
            throw new ZipFileParseException("Internal error for entry " + absoluteLocation);
        }
        if (!zipEntryCentralFileHeaderData.getLocation().equals((Object)absoluteLocation)) {
            throw new ZipFileParseException("Internal error " + zipEntryCentralFileHeaderData.getLocation() + " != " + absoluteLocation);
        }
        if (zipEntryCentralFileHeaderData.isDirectory()) {
            return this.createEmptyDirectoryEntry(zipEntryCollaborator, zipEntryCentralFileHeaderData, zipEntityHolder.m_zeld, absoluteLocation, map);
        }
        if (zipEntryCentralFileHeaderData.getExternalFileAttributes() instanceof UnixExternalFileAttributes) {
            UnixExternalFileAttributes unixExternalFileAttributes = (UnixExternalFileAttributes)zipEntryCentralFileHeaderData.getExternalFileAttributes();
            if (unixExternalFileAttributes.getEntityType() == UnixEntityType.SYMBOLIC_LINK) {
                return this.createSymbolicLinkEntry(zipEntryCollaborator, zipEntryCentralFileHeaderData, zipEntityHolder.m_zeld, absoluteLocation, map, charset);
            }
            if (unixExternalFileAttributes.getEntityType() == UnixEntityType.REGULAR_FILE) {
                return this.createFileEntry(zipEntryCollaborator, zipEntryCentralFileHeaderData, zipEntityHolder.m_zeld, absoluteLocation, map);
            }
            if (unixExternalFileAttributes.getEntityType() == UnixEntityType.DIRECTORY) {
                throw new ZipFileParseException("The unix entity type was directory, but the entry type was a file: " + zipEntryCentralFileHeaderData.getLocation());
            }
            System.out.println("Treating entry of type " + (Object)((Object)unixExternalFileAttributes.getEntityType()) + " as a regular file: " + zipEntryCentralFileHeaderData.getLocation());
            return this.createFileEntry(zipEntryCollaborator, zipEntryCentralFileHeaderData, zipEntityHolder.m_zeld, absoluteLocation, map);
        }
        return this.createFileEntry(zipEntryCollaborator, zipEntryCentralFileHeaderData, zipEntityHolder.m_zeld, absoluteLocation, map);
    }

    private EndOfCentralDirectoryRecordContents parseEndOfCentralDirectoryRecord(RandomAccess randomAccess, Charset charset) {
        int n = 0;
        long l = randomAccess.length();
        if (l < 18L) {
            throw new ZipFileParseException("The file was only " + l + " bytes long. Is this really a Zip file?");
        }
        long l2 = l - 18L;
        randomAccess.seek(l2);
        EndOfCentralDirectoryRecordContents endOfCentralDirectoryRecordContents = new EndOfCentralDirectoryRecordContents();
        boolean bl = false;
        while (!bl) {
            if (randomAccess.read() == END_OF_CENTRAL_DIRECTORY_HEADER_BACKWARDS[n]) {
                if (++n == 4) {
                    randomAccess.skipBytes(15L);
                    endOfCentralDirectoryRecordContents.m_startOfCentralDirectory = UnsignedInteger.readBigEndian(randomAccess);
                    bl = true;
                }
            } else {
                n = 0;
            }
            if (bl) continue;
            if (--l2 < 0L) {
                throw new ZipFileParseException("Could not find the end of central directory header. Is this really a Zip file?");
            }
            if (l - l2 > 67000L) {
                throw new ZipFileParseException("Could not find the end of central directory header. Is this really a Zip file? (If it is, report this as a bug!)");
            }
            randomAccess.seek(l2);
        }
        int n2 = UnsignedShort.readBigEndian(randomAccess).intValue();
        if (n2 > 0) {
            endOfCentralDirectoryRecordContents.m_fileComment = this.readString(randomAccess, n2, charset, false);
        } else {
            endOfCentralDirectoryRecordContents.m_fileComment = "";
        }
        return endOfCentralDirectoryRecordContents;
    }

    private ZipEntryLocalFileHeaderData readLocalFileHeader(RandomAccess randomAccess) {
        ZipEntryLocalFileHeaderData zipEntryLocalFileHeaderData = new ZipEntryLocalFileHeaderData();
        randomAccess.skipBytes(26L);
        UnsignedShort unsignedShort = UnsignedShort.readBigEndian(randomAccess);
        UnsignedShort unsignedShort2 = UnsignedShort.readBigEndian(randomAccess);
        randomAccess.skipBytes((long)unsignedShort.intValue());
        zipEntryLocalFileHeaderData.setExtraFields(this.parseExtraFields(this.readByteArray(randomAccess, unsignedShort2.intValue()), true));
        zipEntryLocalFileHeaderData.setStartPositionOfFileData(randomAccess.getFilePointer());
        return zipEntryLocalFileHeaderData;
    }

    public ZipFileContents parse(ZipEntryCollaborator zipEntryCollaborator, RandomAccess randomAccess, Charset charset, Charset charset2) throws ZipFileParseException, WrappedIOException {
        try {
            Object object3;
            Object object2;
            EndOfCentralDirectoryRecordContents endOfCentralDirectoryRecordContents = this.parseEndOfCentralDirectoryRecord(randomAccess, charset2);
            randomAccess.seek(endOfCentralDirectoryRecordContents.m_startOfCentralDirectory.longValue());
            UnsignedInteger unsignedInteger = UnsignedInteger.readBigEndian(randomAccess);
            byte[] byArray = new byte[4];
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (this.isCentralFileHeader(unsignedInteger)) {
                int n2;
                object2 = this.readCentralFileHeader(randomAccess, charset, charset2);
                if (object2 != null) {
                    ++n;
                    arrayList.add(object2);
                }
                if ((n2 = randomAccess.read(byArray)) != 4) {
                    unsignedInteger = null;
                    continue;
                }
                unsignedInteger = UnsignedInteger.fromBigEndianByteArray(byArray);
            }
            object2 = new ZipEntityHolder();
            for (Object object3 : arrayList) {
                randomAccess.seek(((ZipEntryCentralFileHeaderData)object3).getRelativeOffsetOfLocalHeader().longValue());
                ZipEntryLocalFileHeaderData zipEntryLocalFileHeaderData = this.readLocalFileHeader(randomAccess);
                this.placeEntryInTree((ZipEntityHolder)object2, ((ZipEntryCentralFileHeaderData)object3).getLocation().getPathSegmentStack(), (ZipEntryCentralFileHeaderData)object3, zipEntryLocalFileHeaderData);
            }
            HashMap hashMap = new HashMap(n);
            object3 = this.createEntries(zipEntryCollaborator, (ZipEntityHolder)object2, AbsoluteLocation.ROOT_DIR, hashMap, charset2);
            return new ZipFileContents((ZipDirectoryEntry)object3, hashMap, endOfCentralDirectoryRecordContents.m_fileComment);
        }
        catch (RuntimeException runtimeException) {
            throw new ZipFileParseException("At position " + randomAccess.getFilePointer(), runtimeException);
        }
    }

    private static final class EndOfCentralDirectoryRecordContents {
        private UnsignedInteger m_startOfCentralDirectory;
        private String m_fileComment;

        private EndOfCentralDirectoryRecordContents() {
        }
    }

    private static final class ZipEntityHolder {
        private ZipEntryCentralFileHeaderData m_zecd;
        private ZipEntryLocalFileHeaderData m_zeld;
        private Map<String, ZipEntityHolder> m_childEntities = new HashMap<String, ZipEntityHolder>();

        private ZipEntityHolder() {
        }
    }
}

