/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip;

import org.at4j.support.lang.UnsignedByte;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.zip.comp.Deflate64CompressionMethod;
import org.at4j.zip.comp.DeflatedCompressionMethod;
import org.at4j.zip.comp.ImplodedCompressionMethod;
import org.at4j.zip.comp.LzmaCompressionMethod;
import org.at4j.zip.comp.ZipEntryCompressionMethod;

public class ZipGeneralPurposeBitFlags {
    private boolean m_encrypted;
    private boolean m_8kSlidingDictionary;
    private boolean m_3ShannonFanoTrees;
    private boolean m_maximumCompression;
    private boolean m_fastCompression;
    private boolean m_superFastCompression;
    private boolean m_eosMarkerUsed;
    private boolean m_localHeaderFieldsZeroed;
    private boolean m_compressedPatchedData;
    private boolean m_strongEncryption;
    private boolean m_utf8Encoding;
    private boolean m_localHeaderValuesMasked;

    public ZipGeneralPurposeBitFlags() {
    }

    public ZipGeneralPurposeBitFlags(UnsignedShort unsignedShort) {
        byte[] byArray = unsignedShort.getBigEndianByteArray();
        UnsignedByte unsignedByte = UnsignedByte.valueOf(byArray[0]);
        UnsignedByte unsignedByte2 = UnsignedByte.valueOf(byArray[1]);
        this.m_encrypted = unsignedByte.isBitSet(0);
        this.m_8kSlidingDictionary = unsignedByte.isBitSet(1);
        this.m_3ShannonFanoTrees = unsignedByte.isBitSet(2);
        this.m_maximumCompression = !unsignedByte.isBitSet(2) && unsignedByte.isBitSet(1);
        this.m_fastCompression = unsignedByte.isBitSet(2) && !unsignedByte.isBitSet(1);
        this.m_superFastCompression = unsignedByte.isBitSet(2) && unsignedByte.isBitSet(1);
        this.m_eosMarkerUsed = unsignedByte.isBitSet(1);
        this.m_localHeaderFieldsZeroed = unsignedByte.isBitSet(3);
        this.m_compressedPatchedData = unsignedByte.isBitSet(5);
        this.m_strongEncryption = unsignedByte.isBitSet(6);
        this.m_utf8Encoding = unsignedByte2.isBitSet(3);
        this.m_localHeaderValuesMasked = unsignedByte2.isBitSet(5);
    }

    public boolean isEncrypted() {
        return this.m_encrypted;
    }

    public void setEncrypted(boolean bl) {
        this.m_encrypted = bl;
    }

    public boolean is8kSlidingDictionary() {
        return this.m_8kSlidingDictionary;
    }

    public void set8kSlidingDictionary(boolean bl) {
        this.m_8kSlidingDictionary = bl;
    }

    public boolean is3ShannonFanoTrees() {
        return this.m_3ShannonFanoTrees;
    }

    public void set3ShannonFanoTrees(boolean bl) {
        this.m_3ShannonFanoTrees = bl;
    }

    public boolean isMaximumCompression() {
        return this.m_maximumCompression;
    }

    public void setMaximumCompression(boolean bl) {
        this.m_maximumCompression = bl;
    }

    public boolean isFastCompression() {
        return this.m_fastCompression;
    }

    public void setFastCompression(boolean bl) {
        this.m_fastCompression = bl;
    }

    public boolean isSuperFastCompression() {
        return this.m_superFastCompression;
    }

    public void setSuperFastCompression(boolean bl) {
        this.m_superFastCompression = bl;
    }

    public boolean isEosMarkerUsed() {
        return this.m_eosMarkerUsed;
    }

    public void setEosMarkerUsed(boolean bl) {
        this.m_eosMarkerUsed = bl;
    }

    public boolean isLocalHeaderFieldZeroed() {
        return this.m_localHeaderFieldsZeroed;
    }

    public void setLocalHeaderFieldsZeroed(boolean bl) {
        this.m_localHeaderFieldsZeroed = bl;
    }

    public boolean isCompressedPatchedData() {
        return this.m_compressedPatchedData;
    }

    public void setCompressedPatchedData(boolean bl) {
        this.m_compressedPatchedData = bl;
    }

    public boolean isStrongEncryption() {
        return this.m_strongEncryption;
    }

    public void setStrongEncryption(boolean bl) {
        this.m_strongEncryption = bl;
    }

    public boolean isUtf8Encoding() {
        return this.m_utf8Encoding;
    }

    public void setUtf8Encoding(boolean bl) {
        this.m_utf8Encoding = bl;
    }

    public boolean isLocalHeaderValuesMasked() {
        return this.m_localHeaderValuesMasked;
    }

    public void setLocalHeaderValuesMasked(boolean bl) {
        this.m_localHeaderValuesMasked = bl;
    }

    public byte[] toBytes(ZipEntryCompressionMethod zipEntryCompressionMethod) {
        byte[] byArray = new byte[2];
        if (this.m_encrypted) {
            byArray[0] = 1;
        }
        if (zipEntryCompressionMethod instanceof ImplodedCompressionMethod) {
            if (this.m_8kSlidingDictionary) {
                byArray[0] = (byte)(byArray[0] + 2);
            }
            if (this.m_3ShannonFanoTrees) {
                byArray[0] = (byte)(byArray[0] + 4);
            }
        } else if (zipEntryCompressionMethod instanceof DeflatedCompressionMethod || zipEntryCompressionMethod instanceof Deflate64CompressionMethod) {
            if (this.m_maximumCompression) {
                byArray[0] = (byte)(byArray[0] + 2);
            } else if (this.m_fastCompression) {
                byArray[0] = (byte)(byArray[0] + 4);
            } else if (this.m_superFastCompression) {
                byArray[0] = (byte)(byArray[0] + 6);
            }
        } else if (zipEntryCompressionMethod instanceof LzmaCompressionMethod && this.m_eosMarkerUsed) {
            byArray[0] = (byte)(byArray[0] + 2);
        }
        if (this.m_localHeaderFieldsZeroed) {
            byArray[0] = (byte)(byArray[0] + 8);
        }
        if (this.m_compressedPatchedData) {
            byArray[0] = (byte)(byArray[0] + 32);
        }
        if (this.m_strongEncryption) {
            byArray[0] = (byte)(byArray[0] + 64);
        }
        if (this.m_utf8Encoding) {
            byArray[1] = (byte)(byArray[1] + 8);
        }
        if (this.m_localHeaderValuesMasked) {
            byArray[1] = (byte)(byArray[1] + 32);
        }
        return byArray;
    }
}

